/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.GitLabInterceptor;
import io.fabric8.tekton.triggers.v1alpha1.SecretRef;
import io.fabric8.tekton.triggers.v1alpha1.SecretRefBuilder;
import io.fabric8.tekton.triggers.v1alpha1.SecretRefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GitLabInterceptorFluent<A extends GitLabInterceptorFluent<A>>
extends BaseFluent<A> {
    private List<String> eventTypes = new ArrayList<String>();
    private SecretRefBuilder secretRef;

    public GitLabInterceptorFluent() {
    }

    public GitLabInterceptorFluent(GitLabInterceptor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GitLabInterceptor instance) {
        GitLabInterceptor gitLabInterceptor = instance = instance != null ? instance : new GitLabInterceptor();
        if (instance != null) {
            this.withEventTypes(instance.getEventTypes());
            this.withSecretRef(instance.getSecretRef());
            this.withEventTypes(instance.getEventTypes());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public A addToEventTypes(int index, String item) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<String>();
        }
        this.eventTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToEventTypes(int index, String item) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<String>();
        }
        this.eventTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToEventTypes(String ... items) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToEventTypes(Collection<String> items) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.eventTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromEventTypes(String ... items) {
        if (this.eventTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEventTypes(Collection<String> items) {
        if (this.eventTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.eventTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getEventType(int index) {
        return this.eventTypes.get(index);
    }

    public String getFirstEventType() {
        return this.eventTypes.get(0);
    }

    public String getLastEventType() {
        return this.eventTypes.get(this.eventTypes.size() - 1);
    }

    public String getMatchingEventType(Predicate<String> predicate) {
        for (String item : this.eventTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEventType(Predicate<String> predicate) {
        for (String item : this.eventTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEventTypes(List<String> eventTypes) {
        if (eventTypes != null) {
            this.eventTypes = new ArrayList<String>();
            for (String item : eventTypes) {
                this.addToEventTypes(item);
            }
        } else {
            this.eventTypes = null;
        }
        return (A)((Object)this);
    }

    public A withEventTypes(String ... eventTypes) {
        if (this.eventTypes != null) {
            this.eventTypes.clear();
            this._visitables.remove((Object)"eventTypes");
        }
        if (eventTypes != null) {
            for (String item : eventTypes) {
                this.addToEventTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEventTypes() {
        return this.eventTypes != null && !this.eventTypes.isEmpty();
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String secretKey, String secretName) {
        return this.withSecretRef(new SecretRef(secretKey, secretName));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitLabInterceptorFluent that = (GitLabInterceptorFluent)((Object)o);
        if (!Objects.equals(this.eventTypes, that.eventTypes)) {
            return false;
        }
        return Objects.equals((Object)this.secretRef, (Object)that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventTypes, this.secretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eventTypes != null && !this.eventTypes.isEmpty()) {
            sb.append("eventTypes:");
            sb.append(this.eventTypes + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append((Object)this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)GitLabInterceptorFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

