/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.ClientConfig;
import io.fabric8.tekton.triggers.v1alpha1.ServiceReference;
import io.fabric8.tekton.triggers.v1alpha1.ServiceReferenceBuilder;
import io.fabric8.tekton.triggers.v1alpha1.ServiceReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class ClientConfigFluent<A extends ClientConfigFluent<A>>
extends BaseFluent<A> {
    private String caBundle;
    private ServiceReferenceBuilder service;
    private String url;

    public ClientConfigFluent() {
    }

    public ClientConfigFluent(ClientConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClientConfig instance) {
        ClientConfig clientConfig = instance = instance != null ? instance : new ClientConfig();
        if (instance != null) {
            this.withCaBundle(instance.getCaBundle());
            this.withService(instance.getService());
            this.withUrl(instance.getUrl());
            this.withCaBundle(instance.getCaBundle());
            this.withService(instance.getService());
            this.withUrl(instance.getUrl());
        }
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)((Object)this);
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(ServiceReference service) {
        this._visitables.get((Object)"service").remove((Object)this.service);
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get((Object)"service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get((Object)"service").remove((Object)this.service);
        }
        return (A)((Object)this);
    }

    public boolean hasService() {
        return this.service != null;
    }

    public A withNewService(String name, String namespace, String path, Integer port) {
        return this.withService(new ServiceReference(name, namespace, path, port));
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ServiceReferenceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientConfigFluent that = (ClientConfigFluent)((Object)o);
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals((Object)this.service, (Object)that.service)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.caBundle, this.service, this.url, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append((Object)((Object)this.service) + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceNested<N>
    extends ServiceReferenceFluent<ServiceNested<N>>
    implements Nested<N> {
        ServiceReferenceBuilder builder;

        ServiceNested(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ClientConfigFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

