/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskRunDebugFluent<A extends TaskRunDebugFluent<A>>
extends BaseFluent<A> {
    private List<String> breakpoint = new ArrayList<String>();

    public TaskRunDebugFluent() {
    }

    public TaskRunDebugFluent(TaskRunDebug instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TaskRunDebug instance) {
        TaskRunDebug taskRunDebug = instance = instance != null ? instance : new TaskRunDebug();
        if (instance != null) {
            this.withBreakpoint(instance.getBreakpoint());
            this.withBreakpoint(instance.getBreakpoint());
        }
    }

    public A addToBreakpoint(int index, String item) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        this.breakpoint.add(index, item);
        return (A)((Object)this);
    }

    public A setToBreakpoint(int index, String item) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        this.breakpoint.set(index, item);
        return (A)((Object)this);
    }

    public A addToBreakpoint(String ... items) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        for (String item : items) {
            this.breakpoint.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBreakpoint(Collection<String> items) {
        if (this.breakpoint == null) {
            this.breakpoint = new ArrayList<String>();
        }
        for (String item : items) {
            this.breakpoint.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBreakpoint(String ... items) {
        if (this.breakpoint == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.breakpoint.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBreakpoint(Collection<String> items) {
        if (this.breakpoint == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.breakpoint.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBreakpoint() {
        return this.breakpoint;
    }

    public String getBreakpoint(int index) {
        return this.breakpoint.get(index);
    }

    public String getFirstBreakpoint() {
        return this.breakpoint.get(0);
    }

    public String getLastBreakpoint() {
        return this.breakpoint.get(this.breakpoint.size() - 1);
    }

    public String getMatchingBreakpoint(Predicate<String> predicate) {
        for (String item : this.breakpoint) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBreakpoint(Predicate<String> predicate) {
        for (String item : this.breakpoint) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBreakpoint(List<String> breakpoint) {
        if (breakpoint != null) {
            this.breakpoint = new ArrayList<String>();
            for (String item : breakpoint) {
                this.addToBreakpoint(item);
            }
        } else {
            this.breakpoint = null;
        }
        return (A)((Object)this);
    }

    public A withBreakpoint(String ... breakpoint) {
        if (this.breakpoint != null) {
            this.breakpoint.clear();
            this._visitables.remove((Object)"breakpoint");
        }
        if (breakpoint != null) {
            for (String item : breakpoint) {
                this.addToBreakpoint(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBreakpoint() {
        return this.breakpoint != null && !this.breakpoint.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskRunDebugFluent that = (TaskRunDebugFluent)((Object)o);
        return Objects.equals(this.breakpoint, that.breakpoint);
    }

    public int hashCode() {
        return Objects.hash(this.breakpoint, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.breakpoint != null && !this.breakpoint.isEmpty()) {
            sb.append("breakpoint:");
            sb.append(this.breakpoint);
        }
        sb.append("}");
        return sb.toString();
    }
}

