/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.pipeline.v1beta1.TaskResource;
import io.fabric8.tekton.pipeline.v1beta1.TaskResourceBuilder;
import io.fabric8.tekton.pipeline.v1beta1.TaskResourceFluent;
import io.fabric8.tekton.pipeline.v1beta1.TaskResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TaskResourcesFluent<A extends TaskResourcesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<TaskResourceBuilder> inputs = new ArrayList();
    private ArrayList<TaskResourceBuilder> outputs = new ArrayList();

    public TaskResourcesFluent() {
    }

    public TaskResourcesFluent(TaskResources instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TaskResources instance) {
        TaskResources taskResources = instance = instance != null ? instance : new TaskResources();
        if (instance != null) {
            this.withInputs(instance.getInputs());
            this.withOutputs(instance.getOutputs());
            this.withInputs(instance.getInputs());
            this.withOutputs(instance.getOutputs());
        }
    }

    public A addToInputs(int index, TaskResource item) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        if (index < 0 || index >= this.inputs.size()) {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        } else {
            this._visitables.get((Object)"inputs").add(index, builder);
            this.inputs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInputs(int index, TaskResource item) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        if (index < 0 || index >= this.inputs.size()) {
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        } else {
            this._visitables.get((Object)"inputs").set(index, builder);
            this.inputs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInputs(TaskResource ... items) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToInputs(Collection<TaskResource> items) {
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"inputs").add(builder);
            this.inputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInputs(TaskResource ... items) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"inputs").remove((Object)builder);
            this.inputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromInputs(Collection<TaskResource> items) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"inputs").remove((Object)builder);
            this.inputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromInputs(Predicate<TaskResourceBuilder> predicate) {
        if (this.inputs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskResourceBuilder> each = this.inputs.iterator();
        List visitables = this._visitables.get((Object)"inputs");
        while (each.hasNext()) {
            TaskResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskResource> buildInputs() {
        return this.inputs != null ? TaskResourcesFluent.build(this.inputs) : null;
    }

    public TaskResource buildInput(int index) {
        return this.inputs.get(index).build();
    }

    public TaskResource buildFirstInput() {
        return this.inputs.get(0).build();
    }

    public TaskResource buildLastInput() {
        return this.inputs.get(this.inputs.size() - 1).build();
    }

    public TaskResource buildMatchingInput(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.inputs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInput(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.inputs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInputs(List<TaskResource> inputs) {
        if (this.inputs != null) {
            this._visitables.get((Object)"inputs").clear();
        }
        if (inputs != null) {
            this.inputs = new ArrayList();
            for (TaskResource item : inputs) {
                this.addToInputs(item);
            }
        } else {
            this.inputs = null;
        }
        return (A)((Object)this);
    }

    public A withInputs(TaskResource ... inputs) {
        if (this.inputs != null) {
            this.inputs.clear();
            this._visitables.remove((Object)"inputs");
        }
        if (inputs != null) {
            for (TaskResource item : inputs) {
                this.addToInputs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInputs() {
        return this.inputs != null && !this.inputs.isEmpty();
    }

    public A addNewInput(String description, String name, Boolean optional, String targetPath, String type) {
        return this.addToInputs(new TaskResource(description, name, optional, targetPath, type));
    }

    public InputsNested<A> addNewInput() {
        return new InputsNested(-1, null);
    }

    public InputsNested<A> addNewInputLike(TaskResource item) {
        return new InputsNested(-1, item);
    }

    public InputsNested<A> setNewInputLike(int index, TaskResource item) {
        return new InputsNested(index, item);
    }

    public InputsNested<A> editInput(int index) {
        if (this.inputs.size() <= index) {
            throw new RuntimeException("Can't edit inputs. Index exceeds size.");
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public InputsNested<A> editFirstInput() {
        if (this.inputs.size() == 0) {
            throw new RuntimeException("Can't edit first inputs. The list is empty.");
        }
        return this.setNewInputLike(0, this.buildInput(0));
    }

    public InputsNested<A> editLastInput() {
        int index = this.inputs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last inputs. The list is empty.");
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public InputsNested<A> editMatchingInput(Predicate<TaskResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!predicate.test(this.inputs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching inputs. No match found.");
        }
        return this.setNewInputLike(index, this.buildInput(index));
    }

    public A addToOutputs(int index, TaskResource item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        if (index < 0 || index >= this.outputs.size()) {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        } else {
            this._visitables.get((Object)"outputs").add(index, builder);
            this.outputs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOutputs(int index, TaskResource item) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        if (index < 0 || index >= this.outputs.size()) {
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        } else {
            this._visitables.get((Object)"outputs").set(index, builder);
            this.outputs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOutputs(TaskResource ... items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOutputs(Collection<TaskResource> items) {
        if (this.outputs == null) {
            this.outputs = new ArrayList();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"outputs").add(builder);
            this.outputs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOutputs(TaskResource ... items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"outputs").remove((Object)builder);
            this.outputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOutputs(Collection<TaskResource> items) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"outputs").remove((Object)builder);
            this.outputs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOutputs(Predicate<TaskResourceBuilder> predicate) {
        if (this.outputs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskResourceBuilder> each = this.outputs.iterator();
        List visitables = this._visitables.get((Object)"outputs");
        while (each.hasNext()) {
            TaskResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskResource> buildOutputs() {
        return this.outputs != null ? TaskResourcesFluent.build(this.outputs) : null;
    }

    public TaskResource buildOutput(int index) {
        return this.outputs.get(index).build();
    }

    public TaskResource buildFirstOutput() {
        return this.outputs.get(0).build();
    }

    public TaskResource buildLastOutput() {
        return this.outputs.get(this.outputs.size() - 1).build();
    }

    public TaskResource buildMatchingOutput(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.outputs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOutput(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.outputs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOutputs(List<TaskResource> outputs) {
        if (this.outputs != null) {
            this._visitables.get((Object)"outputs").clear();
        }
        if (outputs != null) {
            this.outputs = new ArrayList();
            for (TaskResource item : outputs) {
                this.addToOutputs(item);
            }
        } else {
            this.outputs = null;
        }
        return (A)((Object)this);
    }

    public A withOutputs(TaskResource ... outputs) {
        if (this.outputs != null) {
            this.outputs.clear();
            this._visitables.remove((Object)"outputs");
        }
        if (outputs != null) {
            for (TaskResource item : outputs) {
                this.addToOutputs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOutputs() {
        return this.outputs != null && !this.outputs.isEmpty();
    }

    public A addNewOutput(String description, String name, Boolean optional, String targetPath, String type) {
        return this.addToOutputs(new TaskResource(description, name, optional, targetPath, type));
    }

    public OutputsNested<A> addNewOutput() {
        return new OutputsNested(-1, null);
    }

    public OutputsNested<A> addNewOutputLike(TaskResource item) {
        return new OutputsNested(-1, item);
    }

    public OutputsNested<A> setNewOutputLike(int index, TaskResource item) {
        return new OutputsNested(index, item);
    }

    public OutputsNested<A> editOutput(int index) {
        if (this.outputs.size() <= index) {
            throw new RuntimeException("Can't edit outputs. Index exceeds size.");
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public OutputsNested<A> editFirstOutput() {
        if (this.outputs.size() == 0) {
            throw new RuntimeException("Can't edit first outputs. The list is empty.");
        }
        return this.setNewOutputLike(0, this.buildOutput(0));
    }

    public OutputsNested<A> editLastOutput() {
        int index = this.outputs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last outputs. The list is empty.");
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public OutputsNested<A> editMatchingOutput(Predicate<TaskResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!predicate.test(this.outputs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching outputs. No match found.");
        }
        return this.setNewOutputLike(index, this.buildOutput(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskResourcesFluent that = (TaskResourcesFluent)((Object)o);
        if (!Objects.equals(this.inputs, that.inputs)) {
            return false;
        }
        return Objects.equals(this.outputs, that.outputs);
    }

    public int hashCode() {
        return Objects.hash(this.inputs, this.outputs, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.inputs != null && !this.inputs.isEmpty()) {
            sb.append("inputs:");
            sb.append(this.inputs + ",");
        }
        if (this.outputs != null && !this.outputs.isEmpty()) {
            sb.append("outputs:");
            sb.append(this.outputs);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OutputsNested<N>
    extends TaskResourceFluent<OutputsNested<N>>
    implements Nested<N> {
        TaskResourceBuilder builder;
        int index;

        OutputsNested(int index, TaskResource item) {
            this.index = index;
            this.builder = new TaskResourceBuilder(this, item);
        }

        public N and() {
            return (N)TaskResourcesFluent.this.setToOutputs(this.index, this.builder.build());
        }

        public N endOutput() {
            return this.and();
        }
    }

    public class InputsNested<N>
    extends TaskResourceFluent<InputsNested<N>>
    implements Nested<N> {
        TaskResourceBuilder builder;
        int index;

        InputsNested(int index, TaskResource item) {
            this.index = index;
            this.builder = new TaskResourceBuilder(this, item);
        }

        public N and() {
            return (N)TaskResourcesFluent.this.setToInputs(this.index, this.builder.build());
        }

        public N endInput() {
            return this.and();
        }
    }
}

