package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.Param;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebhookInterceptorFluent<A extends WebhookInterceptorFluent<A>> extends BaseFluent<A>{
  public WebhookInterceptorFluent() {
  }
  
  public WebhookInterceptorFluent(WebhookInterceptor instance) {
    this.copyInstance(instance);
  }
  private List<Param> header = new ArrayList<Param>();
  private ObjectReferenceBuilder objectRef;
  private String url;
  
  protected void copyInstance(WebhookInterceptor instance) {
    instance = (instance != null ? instance : new WebhookInterceptor());
  
    if (instance != null) {
        this.withHeader(instance.getHeader());
        this.withObjectRef(instance.getObjectRef());
        this.withUrl(instance.getUrl());
        this.withHeader(instance.getHeader());
        this.withObjectRef(instance.getObjectRef());
        this.withUrl(instance.getUrl());
      }
  }
  
  public A addToHeader(int index,Param item) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    this.header.add(index, item);
    return (A)this;
  }
  
  public A setToHeader(int index,Param item) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    this.header.set(index, item); return (A)this;
  }
  
  public A addToHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    for (Param item : items) {this.header.add(item);} return (A)this;
  }
  
  public A addAllToHeader(Collection<Param> items) {
    if (this.header == null) {this.header = new ArrayList<Param>();}
    for (Param item : items) {this.header.add(item);} return (A)this;
  }
  
  public A removeFromHeader(io.fabric8.tekton.pipeline.v1beta1.Param... items) {
    if (this.header == null) return (A)this;
    for (Param item : items) { this.header.remove(item);} return (A)this;
  }
  
  public A removeAllFromHeader(Collection<Param> items) {
    if (this.header == null) return (A)this;
    for (Param item : items) { this.header.remove(item);} return (A)this;
  }
  
  public List<Param> getHeader() {
    return this.header;
  }
  
  public Param getHeader(int index) {
    return this.header.get(index);
  }
  
  public Param getFirstHeader() {
    return this.header.get(0);
  }
  
  public Param getLastHeader() {
    return this.header.get(header.size() - 1);
  }
  
  public Param getMatchingHeader(Predicate<Param> predicate) {
    for (Param item: header) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingHeader(Predicate<Param> predicate) {
    for (Param item: header) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withHeader(List<Param> header) {
    if (header != null) {this.header = new ArrayList(); for (Param item : header){this.addToHeader(item);}} else { this.header = null;} return (A) this;
  }
  
  public A withHeader(io.fabric8.tekton.pipeline.v1beta1.Param... header) {
    if (this.header != null) {this.header.clear(); _visitables.remove("header"); }
    if (header != null) {for (Param item :header){ this.addToHeader(item);}} return (A) this;
  }
  
  public boolean hasHeader() {
    return header != null && !header.isEmpty();
  }
  
  public ObjectReference buildObjectRef() {
    return this.objectRef!=null ?this.objectRef.build():null;
  }
  
  public A withObjectRef(ObjectReference objectRef) {
    _visitables.get("objectRef").remove(this.objectRef);
    if (objectRef!=null){ this.objectRef= new ObjectReferenceBuilder(objectRef); _visitables.get("objectRef").add(this.objectRef);} else { this.objectRef = null; _visitables.get("objectRef").remove(this.objectRef); } return (A) this;
  }
  
  public boolean hasObjectRef() {
    return this.objectRef != null;
  }
  
  public ObjectRefNested<A> withNewObjectRef() {
    return new ObjectRefNested(null);
  }
  
  public ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
    return new ObjectRefNested(item);
  }
  
  public ObjectRefNested<A> editObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(null));
  }
  
  public ObjectRefNested<A> editOrNewObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebhookInterceptorFluent that = (WebhookInterceptorFluent) o;
    if (!java.util.Objects.equals(header, that.header)) return false;
  
    if (!java.util.Objects.equals(objectRef, that.objectRef)) return false;
  
    if (!java.util.Objects.equals(url, that.url)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(header,  objectRef,  url,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (header != null && !header.isEmpty()) { sb.append("header:"); sb.append(header + ","); }
    if (objectRef != null) { sb.append("objectRef:"); sb.append(objectRef + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  public class ObjectRefNested<N> extends ObjectReferenceFluent<ObjectRefNested<N>> implements Nested<N>{
    ObjectRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) WebhookInterceptorFluent.this.withObjectRef(builder.build());
    }
    
    public N endObjectRef() {
      return and();
    }
    
  
  }

}