package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourcesFluent<A extends ResourcesFluent<A>> extends BaseFluent<A>{
  public ResourcesFluent() {
  }
  
  public ResourcesFluent(Resources instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends HasMetadata,?> customResource;
  private KubernetesResourceBuilder kubernetesResource;
  
  protected void copyInstance(Resources instance) {
    instance = (instance != null ? instance : new Resources());
  
    if (instance != null) {
        this.withCustomResource(instance.getCustomResource());
        this.withKubernetesResource(instance.getKubernetesResource());
        this.withCustomResource(instance.getCustomResource());
        this.withKubernetesResource(instance.getKubernetesResource());
      }
  }
  
  public HasMetadata buildCustomResource() {
    return this.customResource!=null?this.customResource.build():null;
  }
  
  public A withCustomResource(HasMetadata customResource) {
    if (customResource==null){ this.customResource = null; _visitables.remove("customResource"); return (A) this;}
    VisitableBuilder<? extends HasMetadata,?> builder = builder(customResource); _visitables.get("customResource").clear();_visitables.get("customResource").add(builder);this.customResource = builder;
    return (A) this;
  }
  
  public boolean hasCustomResource() {
    return this.customResource != null;
  }
  
  public TriggerTemplateCustomResourceNested<A> withNewTriggerTemplateCustomResource() {
    return new TriggerTemplateCustomResourceNested(null);
  }
  
  public TriggerTemplateCustomResourceNested<A> withNewTriggerTemplateCustomResourceLike(TriggerTemplate item) {
    return new TriggerTemplateCustomResourceNested(item);
  }
  
  public ClusterInterceptorCustomResourceNested<A> withNewClusterInterceptorCustomResource() {
    return new ClusterInterceptorCustomResourceNested(null);
  }
  
  public ClusterInterceptorCustomResourceNested<A> withNewClusterInterceptorCustomResourceLike(ClusterInterceptor item) {
    return new ClusterInterceptorCustomResourceNested(item);
  }
  
  public TriggerBindingCustomResourceNested<A> withNewTriggerBindingCustomResource() {
    return new TriggerBindingCustomResourceNested(null);
  }
  
  public TriggerBindingCustomResourceNested<A> withNewTriggerBindingCustomResourceLike(TriggerBinding item) {
    return new TriggerBindingCustomResourceNested(item);
  }
  
  public ClusterTriggerBindingCustomResourceNested<A> withNewClusterTriggerBindingCustomResource() {
    return new ClusterTriggerBindingCustomResourceNested(null);
  }
  
  public ClusterTriggerBindingCustomResourceNested<A> withNewClusterTriggerBindingCustomResourceLike(ClusterTriggerBinding item) {
    return new ClusterTriggerBindingCustomResourceNested(item);
  }
  
  public InterceptorCustomResourceNested<A> withNewInterceptorCustomResource() {
    return new InterceptorCustomResourceNested(null);
  }
  
  public InterceptorCustomResourceNested<A> withNewInterceptorCustomResourceLike(Interceptor item) {
    return new InterceptorCustomResourceNested(item);
  }
  
  public PersistentVolumeClaimCustomResourceNested<A> withNewPersistentVolumeClaimCustomResource() {
    return new PersistentVolumeClaimCustomResourceNested(null);
  }
  
  public PersistentVolumeClaimCustomResourceNested<A> withNewPersistentVolumeClaimCustomResourceLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimCustomResourceNested(item);
  }
  
  public GenericKubernetesResourceCustomNested<A> withNewGenericKubernetesResourceCustom() {
    return new GenericKubernetesResourceCustomNested(null);
  }
  
  public GenericKubernetesResourceCustomNested<A> withNewGenericKubernetesResourceCustomLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceCustomNested(item);
  }
  
  public EventListenerCustomResourceNested<A> withNewEventListenerCustomResource() {
    return new EventListenerCustomResourceNested(null);
  }
  
  public EventListenerCustomResourceNested<A> withNewEventListenerCustomResourceLike(EventListener item) {
    return new EventListenerCustomResourceNested(item);
  }
  
  public TriggerCustomResourceNested<A> withNewTriggerCustomResource() {
    return new TriggerCustomResourceNested(null);
  }
  
  public TriggerCustomResourceNested<A> withNewTriggerCustomResourceLike(Trigger item) {
    return new TriggerCustomResourceNested(item);
  }
  
  public KubernetesResource buildKubernetesResource() {
    return this.kubernetesResource!=null ?this.kubernetesResource.build():null;
  }
  
  public A withKubernetesResource(KubernetesResource kubernetesResource) {
    _visitables.get("kubernetesResource").remove(this.kubernetesResource);
    if (kubernetesResource!=null){ this.kubernetesResource= new KubernetesResourceBuilder(kubernetesResource); _visitables.get("kubernetesResource").add(this.kubernetesResource);} else { this.kubernetesResource = null; _visitables.get("kubernetesResource").remove(this.kubernetesResource); } return (A) this;
  }
  
  public boolean hasKubernetesResource() {
    return this.kubernetesResource != null;
  }
  
  public KubernetesResourceNested<A> withNewKubernetesResource() {
    return new KubernetesResourceNested(null);
  }
  
  public KubernetesResourceNested<A> withNewKubernetesResourceLike(KubernetesResource item) {
    return new KubernetesResourceNested(item);
  }
  
  public KubernetesResourceNested<A> editKubernetesResource() {
    return withNewKubernetesResourceLike(java.util.Optional.ofNullable(buildKubernetesResource()).orElse(null));
  }
  
  public KubernetesResourceNested<A> editOrNewKubernetesResource() {
    return withNewKubernetesResourceLike(java.util.Optional.ofNullable(buildKubernetesResource()).orElse(new KubernetesResourceBuilder().build()));
  }
  
  public KubernetesResourceNested<A> editOrNewKubernetesResourceLike(KubernetesResource item) {
    return withNewKubernetesResourceLike(java.util.Optional.ofNullable(buildKubernetesResource()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourcesFluent that = (ResourcesFluent) o;
    if (!java.util.Objects.equals(customResource, that.customResource)) return false;
  
    if (!java.util.Objects.equals(kubernetesResource, that.kubernetesResource)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(customResource,  kubernetesResource,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customResource != null) { sb.append("customResource:"); sb.append(customResource + ","); }
    if (kubernetesResource != null) { sb.append("kubernetesResource:"); sb.append(kubernetesResource); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.tekton.triggers.v1alpha1."+"TriggerTemplate": return (VisitableBuilder<T, ?>)new TriggerTemplateBuilder((TriggerTemplate) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"ClusterInterceptor": return (VisitableBuilder<T, ?>)new ClusterInterceptorBuilder((ClusterInterceptor) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"TriggerBinding": return (VisitableBuilder<T, ?>)new TriggerBindingBuilder((TriggerBinding) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"ClusterTriggerBinding": return (VisitableBuilder<T, ?>)new ClusterTriggerBindingBuilder((ClusterTriggerBinding) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"Interceptor": return (VisitableBuilder<T, ?>)new InterceptorBuilder((Interceptor) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"EventListener": return (VisitableBuilder<T, ?>)new EventListenerBuilder((EventListener) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"Trigger": return (VisitableBuilder<T, ?>)new TriggerBuilder((Trigger) item);
    }
   return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class TriggerTemplateCustomResourceNested<N> extends TriggerTemplateFluent<TriggerTemplateCustomResourceNested<N>> implements Nested<N>{
    TriggerTemplateCustomResourceNested(TriggerTemplate item) {
      this.builder = new TriggerTemplateBuilder(this, item);
    }
    TriggerTemplateBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endTriggerTemplateCustomResource() {
      return and();
    }
    
  
  }
  public class ClusterInterceptorCustomResourceNested<N> extends ClusterInterceptorFluent<ClusterInterceptorCustomResourceNested<N>> implements Nested<N>{
    ClusterInterceptorCustomResourceNested(ClusterInterceptor item) {
      this.builder = new ClusterInterceptorBuilder(this, item);
    }
    ClusterInterceptorBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endClusterInterceptorCustomResource() {
      return and();
    }
    
  
  }
  public class TriggerBindingCustomResourceNested<N> extends TriggerBindingFluent<TriggerBindingCustomResourceNested<N>> implements Nested<N>{
    TriggerBindingCustomResourceNested(TriggerBinding item) {
      this.builder = new TriggerBindingBuilder(this, item);
    }
    TriggerBindingBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endTriggerBindingCustomResource() {
      return and();
    }
    
  
  }
  public class ClusterTriggerBindingCustomResourceNested<N> extends ClusterTriggerBindingFluent<ClusterTriggerBindingCustomResourceNested<N>> implements Nested<N>{
    ClusterTriggerBindingCustomResourceNested(ClusterTriggerBinding item) {
      this.builder = new ClusterTriggerBindingBuilder(this, item);
    }
    ClusterTriggerBindingBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endClusterTriggerBindingCustomResource() {
      return and();
    }
    
  
  }
  public class InterceptorCustomResourceNested<N> extends InterceptorFluent<InterceptorCustomResourceNested<N>> implements Nested<N>{
    InterceptorCustomResourceNested(Interceptor item) {
      this.builder = new InterceptorBuilder(this, item);
    }
    InterceptorBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endInterceptorCustomResource() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimCustomResourceNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimCustomResourceNested<N>> implements Nested<N>{
    PersistentVolumeClaimCustomResourceNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endPersistentVolumeClaimCustomResource() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceCustomNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceCustomNested<N>> implements Nested<N>{
    GenericKubernetesResourceCustomNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endGenericKubernetesResourceCustom() {
      return and();
    }
    
  
  }
  public class EventListenerCustomResourceNested<N> extends EventListenerFluent<EventListenerCustomResourceNested<N>> implements Nested<N>{
    EventListenerCustomResourceNested(EventListener item) {
      this.builder = new EventListenerBuilder(this, item);
    }
    EventListenerBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endEventListenerCustomResource() {
      return and();
    }
    
  
  }
  public class TriggerCustomResourceNested<N> extends TriggerFluent<TriggerCustomResourceNested<N>> implements Nested<N>{
    TriggerCustomResourceNested(Trigger item) {
      this.builder = new TriggerBuilder(this, item);
    }
    TriggerBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withCustomResource(builder.build());
    }
    
    public N endTriggerCustomResource() {
      return and();
    }
    
  
  }
  public class KubernetesResourceNested<N> extends KubernetesResourceFluent<KubernetesResourceNested<N>> implements Nested<N>{
    KubernetesResourceNested(KubernetesResource item) {
      this.builder = new KubernetesResourceBuilder(this, item);
    }
    KubernetesResourceBuilder builder;
    
    public N and() {
      return (N) ResourcesFluent.this.withKubernetesResource(builder.build());
    }
    
    public N endKubernetesResource() {
      return and();
    }
    
  
  }

}