package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterInterceptorBuilder extends ClusterInterceptorFluent<ClusterInterceptorBuilder> implements VisitableBuilder<ClusterInterceptor,ClusterInterceptorBuilder>{
  public ClusterInterceptorBuilder() {
    this(new ClusterInterceptor());
  }
  
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent) {
    this(fluent, new ClusterInterceptor());
  }
  
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent,ClusterInterceptor instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterInterceptorBuilder(ClusterInterceptor instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterInterceptorFluent<?> fluent;
  
  public ClusterInterceptor build() {
    ClusterInterceptor buildable = new ClusterInterceptor(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}