package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClientConfigFluent<A extends ClientConfigFluent<A>> extends BaseFluent<A>{
  public ClientConfigFluent() {
  }
  
  public ClientConfigFluent(ClientConfig instance) {
    this.copyInstance(instance);
  }
  private String caBundle;
  private ServiceReferenceBuilder service;
  private String url;
  
  protected void copyInstance(ClientConfig instance) {
    instance = (instance != null ? instance : new ClientConfig());
  
    if (instance != null) {
        this.withCaBundle(instance.getCaBundle());
        this.withService(instance.getService());
        this.withUrl(instance.getUrl());
        this.withCaBundle(instance.getCaBundle());
        this.withService(instance.getService());
        this.withUrl(instance.getUrl());
      }
  }
  
  public String getCaBundle() {
    return this.caBundle;
  }
  
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  
  public boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  public ServiceReference buildService() {
    return this.service!=null ?this.service.build():null;
  }
  
  public A withService(ServiceReference service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A withNewService(String name,String namespace,String path,Integer port) {
    return (A)withService(new ServiceReference(name, namespace, path, port));
  }
  
  public ServiceNested<A> withNewService() {
    return new ServiceNested(null);
  }
  
  public ServiceNested<A> withNewServiceLike(ServiceReference item) {
    return new ServiceNested(item);
  }
  
  public ServiceNested<A> editService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(null));
  }
  
  public ServiceNested<A> editOrNewService() {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(new ServiceReferenceBuilder().build()));
  }
  
  public ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
    return withNewServiceLike(java.util.Optional.ofNullable(buildService()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClientConfigFluent that = (ClientConfigFluent) o;
    if (!java.util.Objects.equals(caBundle, that.caBundle)) return false;
  
    if (!java.util.Objects.equals(service, that.service)) return false;
  
    if (!java.util.Objects.equals(url, that.url)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(caBundle,  service,  url,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceNested<N> extends ServiceReferenceFluent<ServiceNested<N>> implements Nested<N>{
    ServiceNested(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceReferenceBuilder builder;
    
    public N and() {
      return (N) ClientConfigFluent.this.withService(builder.build());
    }
    
    public N endService() {
      return and();
    }
    
  
  }

}