package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BitbucketInterceptorFluent<A extends BitbucketInterceptorFluent<A>> extends BaseFluent<A>{
  public BitbucketInterceptorFluent() {
  }
  
  public BitbucketInterceptorFluent(BitbucketInterceptor instance) {
    this.copyInstance(instance);
  }
  private List<String> eventTypes = new ArrayList<String>();
  private SecretRefBuilder secretRef;
  
  protected void copyInstance(BitbucketInterceptor instance) {
    instance = (instance != null ? instance : new BitbucketInterceptor());
  
    if (instance != null) {
        this.withEventTypes(instance.getEventTypes());
        this.withSecretRef(instance.getSecretRef());
        this.withEventTypes(instance.getEventTypes());
        this.withSecretRef(instance.getSecretRef());
      }
  }
  
  public A addToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.add(index, item);
    return (A)this;
  }
  
  public A setToEventTypes(int index,String item) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    this.eventTypes.set(index, item); return (A)this;
  }
  
  public A addToEventTypes(java.lang.String... items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  
  public A addAllToEventTypes(Collection<String> items) {
    if (this.eventTypes == null) {this.eventTypes = new ArrayList<String>();}
    for (String item : items) {this.eventTypes.add(item);} return (A)this;
  }
  
  public A removeFromEventTypes(java.lang.String... items) {
    if (this.eventTypes == null) return (A)this;
    for (String item : items) { this.eventTypes.remove(item);} return (A)this;
  }
  
  public A removeAllFromEventTypes(Collection<String> items) {
    if (this.eventTypes == null) return (A)this;
    for (String item : items) { this.eventTypes.remove(item);} return (A)this;
  }
  
  public List<String> getEventTypes() {
    return this.eventTypes;
  }
  
  public String getEventType(int index) {
    return this.eventTypes.get(index);
  }
  
  public String getFirstEventType() {
    return this.eventTypes.get(0);
  }
  
  public String getLastEventType() {
    return this.eventTypes.get(eventTypes.size() - 1);
  }
  
  public String getMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingEventType(Predicate<String> predicate) {
    for (String item: eventTypes) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withEventTypes(List<String> eventTypes) {
    if (eventTypes != null) {this.eventTypes = new ArrayList(); for (String item : eventTypes){this.addToEventTypes(item);}} else { this.eventTypes = null;} return (A) this;
  }
  
  public A withEventTypes(java.lang.String... eventTypes) {
    if (this.eventTypes != null) {this.eventTypes.clear(); _visitables.remove("eventTypes"); }
    if (eventTypes != null) {for (String item :eventTypes){ this.addToEventTypes(item);}} return (A) this;
  }
  
  public boolean hasEventTypes() {
    return eventTypes != null && !eventTypes.isEmpty();
  }
  
  public SecretRef buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  
  public A withSecretRef(SecretRef secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new SecretRefBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public A withNewSecretRef(String secretKey,String secretName) {
    return (A)withSecretRef(new SecretRef(secretKey, secretName));
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new SecretRefBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BitbucketInterceptorFluent that = (BitbucketInterceptorFluent) o;
    if (!java.util.Objects.equals(eventTypes, that.eventTypes)) return false;
  
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(eventTypes,  secretRef,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (eventTypes != null && !eventTypes.isEmpty()) { sb.append("eventTypes:"); sb.append(eventTypes + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretRefNested<N> extends SecretRefFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(SecretRef item) {
      this.builder = new SecretRefBuilder(this, item);
    }
    SecretRefBuilder builder;
    
    public N and() {
      return (N) BitbucketInterceptorFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }

}