/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.pipeline.pod;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.PodDNSConfig;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.pipeline.pod.Template;
import io.fabric8.tekton.v1beta1.internal.pipeline.pkg.apis.pipeline.pod.TemplateFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TemplateFluentImpl<A extends TemplateFluent<A>>
extends BaseFluent<A>
implements TemplateFluent<A> {
    private Affinity affinity;
    private Boolean automountServiceAccountToken;
    private PodDNSConfig dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private List<HostAlias> hostAliases = new ArrayList<HostAlias>();
    private Boolean hostNetwork;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private Map<String, String> nodeSelector;
    private String priorityClassName;
    private String runtimeClassName;
    private String schedulerName;
    private PodSecurityContext securityContext;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();

    public TemplateFluentImpl() {
    }

    public TemplateFluentImpl(Template instance) {
        if (instance != null) {
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEnv(instance.getEnv());
            this.withHostAliases(instance.getHostAliases());
            this.withHostNetwork(instance.getHostNetwork());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSecurityContext(instance.getSecurityContext());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
        }
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    @Override
    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return this.env != null ? TemplateFluentImpl.build(this.env) : null;
    }

    @Override
    public List<EnvVar> buildEnv() {
        return this.env != null ? TemplateFluentImpl.build(this.env) : null;
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public TemplateFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public TemplateFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public TemplateFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public TemplateFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public TemplateFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public TemplateFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public TemplateFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        this.hostAliases.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<HostAlias>();
        }
        for (HostAlias item : items) {
            this.hostAliases.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    @Override
    public HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    @Override
    public HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    @Override
    public HostAlias getLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1);
    }

    @Override
    public HostAlias getMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAlias> predicate) {
        for (HostAlias item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (hostAliases != null) {
            this.hostAliases = new ArrayList<HostAlias>();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove((Object)"hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get((Object)"imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get((Object)"imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        List visitables = this._visitables.get((Object)"imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets != null ? TemplateFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? TemplateFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get((Object)"imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove((Object)"imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public TemplateFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    @Override
    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    @Override
    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    @Override
    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    @Override
    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove((Object)"topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return this.volumes != null ? TemplateFluentImpl.build(this.volumes) : null;
    }

    @Override
    public List<Volume> buildVolumes() {
        return this.volumes != null ? TemplateFluentImpl.build(this.volumes) : null;
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public TemplateFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public TemplateFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public TemplateFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public TemplateFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public TemplateFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public TemplateFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public TemplateFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateFluentImpl that = (TemplateFluentImpl)o;
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableServiceLinks, that.enableServiceLinks)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassName, that.runtimeClassName)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.affinity, this.automountServiceAccountToken, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.env, this.hostAliases, this.hostNetwork, this.imagePullSecrets, this.nodeSelector, this.priorityClassName, this.runtimeClassName, this.schedulerName, this.securityContext, this.tolerations, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.env != null) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.imagePullSecrets != null) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    @Override
    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    @Override
    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    class VolumesNestedImpl<N>
    extends VolumeFluentImpl<TemplateFluent.VolumesNested<N>>
    implements TemplateFluent.VolumesNested<N>,
    Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)TemplateFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<TemplateFluent.ImagePullSecretsNested<N>>
    implements TemplateFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNestedImpl(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)TemplateFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    class EnvNestedImpl<N>
    extends EnvVarFluentImpl<TemplateFluent.EnvNested<N>>
    implements TemplateFluent.EnvNested<N>,
    Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder((EnvVarFluent)this);
        }

        @Override
        public N and() {
            return (N)TemplateFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

