/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionBuilder;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionFluentImpl;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.Addressable;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableBuilder;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableFluentImpl;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfig;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfigBuilder;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerConfigFluentImpl;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerStatus;
import io.fabric8.tekton.triggers.v1alpha1.EventListenerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EventListenerStatusFluentImpl<A extends EventListenerStatusFluent<A>>
extends BaseFluent<A>
implements EventListenerStatusFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private EventListenerConfigBuilder configuration;
    private Long observedGeneration;

    public EventListenerStatusFluentImpl() {
    }

    public EventListenerStatusFluentImpl(EventListenerStatus instance) {
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withConfiguration(instance.getConfiguration());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    @Override
    @Deprecated
    public Addressable getAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove(this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove(this.address);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewV1alpha1Address(String hostname, String url) {
        return this.withAddress(new Addressable(hostname, url));
    }

    @Override
    public EventListenerStatusFluent.V1alpha1AddressNested<A> withNewV1alpha1Address() {
        return new V1alpha1AddressNestedImpl();
    }

    @Override
    public EventListenerStatusFluent.V1alpha1AddressNested<A> withNewAddressLike(Addressable item) {
        return new V1alpha1AddressNestedImpl(item);
    }

    @Override
    public EventListenerStatusFluent.V1alpha1AddressNested<A> editV1alpha1Address() {
        return this.withNewAddressLike(this.getAddress());
    }

    @Override
    public EventListenerStatusFluent.V1alpha1AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : new AddressableBuilder().build());
    }

    @Override
    public EventListenerStatusFluent.V1alpha1AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : item);
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return this.conditions != null ? EventListenerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<Condition> buildConditions() {
        return this.conditions != null ? EventListenerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public EventListenerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public EventListenerConfig getConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public EventListenerConfig buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    @Override
    public A withConfiguration(EventListenerConfig configuration) {
        this._visitables.get((Object)"configuration").remove(this.configuration);
        if (configuration != null) {
            this.configuration = new EventListenerConfigBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove(this.configuration);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    @Override
    public A withNewConfiguration(String generatedName) {
        return this.withConfiguration(new EventListenerConfig(generatedName));
    }

    @Override
    public EventListenerStatusFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    @Override
    public EventListenerStatusFluent.ConfigurationNested<A> withNewConfigurationLike(EventListenerConfig item) {
        return new ConfigurationNestedImpl(item);
    }

    @Override
    public EventListenerStatusFluent.ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration());
    }

    @Override
    public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : new EventListenerConfigBuilder().build());
    }

    @Override
    public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfigurationLike(EventListenerConfig item) {
        return this.withNewConfigurationLike(this.getConfiguration() != null ? this.getConfiguration() : item);
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventListenerStatusFluentImpl that = (EventListenerStatusFluentImpl)o;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        return Objects.equals(this.observedGeneration, that.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.annotations, this.conditions, this.configuration, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConfigurationNestedImpl<N>
    extends EventListenerConfigFluentImpl<EventListenerStatusFluent.ConfigurationNested<N>>
    implements EventListenerStatusFluent.ConfigurationNested<N>,
    Nested<N> {
        EventListenerConfigBuilder builder;

        ConfigurationNestedImpl(EventListenerConfig item) {
            this.builder = new EventListenerConfigBuilder(this, item);
        }

        ConfigurationNestedImpl() {
            this.builder = new EventListenerConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventListenerStatusFluentImpl.this.withConfiguration(this.builder.build());
        }

        @Override
        public N endConfiguration() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<EventListenerStatusFluent.ConditionsNested<N>>
    implements EventListenerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventListenerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class V1alpha1AddressNestedImpl<N>
    extends AddressableFluentImpl<EventListenerStatusFluent.V1alpha1AddressNested<N>>
    implements EventListenerStatusFluent.V1alpha1AddressNested<N>,
    Nested<N> {
        AddressableBuilder builder;

        V1alpha1AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        V1alpha1AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventListenerStatusFluentImpl.this.withAddress(this.builder.build());
        }

        @Override
        public N endV1alpha1Address() {
            return this.and();
        }
    }
}

