/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.CELInterceptor;
import io.fabric8.tekton.triggers.v1alpha1.CELInterceptorFluent;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlay;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlayBuilder;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlayFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CELInterceptorFluentImpl<A extends CELInterceptorFluent<A>>
extends BaseFluent<A>
implements CELInterceptorFluent<A> {
    private String filter;
    private ArrayList<CELOverlayBuilder> overlays = new ArrayList();

    public CELInterceptorFluentImpl() {
    }

    public CELInterceptorFluentImpl(CELInterceptor instance) {
        if (instance != null) {
            this.withFilter(instance.getFilter());
            this.withOverlays(instance.getOverlays());
        }
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public A withFilter(String filter) {
        this.filter = filter;
        return (A)this;
    }

    @Override
    public Boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public A addToOverlays(int index, CELOverlay item) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        CELOverlayBuilder builder = new CELOverlayBuilder(item);
        if (index < 0 || index >= this.overlays.size()) {
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        } else {
            this._visitables.get((Object)"overlays").add(index, builder);
            this.overlays.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToOverlays(int index, CELOverlay item) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        CELOverlayBuilder builder = new CELOverlayBuilder(item);
        if (index < 0 || index >= this.overlays.size()) {
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        } else {
            this._visitables.get((Object)"overlays").set(index, builder);
            this.overlays.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOverlays(CELOverlay ... items) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOverlays(Collection<CELOverlay> items) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverlays(CELOverlay ... items) {
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").remove(builder);
            if (this.overlays == null) continue;
            this.overlays.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOverlays(Collection<CELOverlay> items) {
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").remove(builder);
            if (this.overlays == null) continue;
            this.overlays.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOverlays(Predicate<CELOverlayBuilder> predicate) {
        if (this.overlays == null) {
            return (A)this;
        }
        Iterator<CELOverlayBuilder> each = this.overlays.iterator();
        List visitables = this._visitables.get((Object)"overlays");
        while (each.hasNext()) {
            CELOverlayBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CELOverlay> getOverlays() {
        return this.overlays != null ? CELInterceptorFluentImpl.build(this.overlays) : null;
    }

    @Override
    public List<CELOverlay> buildOverlays() {
        return this.overlays != null ? CELInterceptorFluentImpl.build(this.overlays) : null;
    }

    @Override
    public CELOverlay buildOverlay(int index) {
        return this.overlays.get(index).build();
    }

    @Override
    public CELOverlay buildFirstOverlay() {
        return this.overlays.get(0).build();
    }

    @Override
    public CELOverlay buildLastOverlay() {
        return this.overlays.get(this.overlays.size() - 1).build();
    }

    @Override
    public CELOverlay buildMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        for (CELOverlayBuilder item : this.overlays) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        for (CELOverlayBuilder item : this.overlays) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOverlays(List<CELOverlay> overlays) {
        if (this.overlays != null) {
            this._visitables.get((Object)"overlays").clear();
        }
        if (overlays != null) {
            this.overlays = new ArrayList();
            for (CELOverlay item : overlays) {
                this.addToOverlays(item);
            }
        } else {
            this.overlays = null;
        }
        return (A)this;
    }

    @Override
    public A withOverlays(CELOverlay ... overlays) {
        if (this.overlays != null) {
            this.overlays.clear();
            this._visitables.remove((Object)"overlays");
        }
        if (overlays != null) {
            for (CELOverlay item : overlays) {
                this.addToOverlays(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverlays() {
        return this.overlays != null && !this.overlays.isEmpty();
    }

    @Override
    public A addNewOverlay(String expression, String key) {
        return this.addToOverlays(new CELOverlay(expression, key));
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> addNewOverlay() {
        return new OverlaysNestedImpl();
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> addNewOverlayLike(CELOverlay item) {
        return new OverlaysNestedImpl(-1, item);
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> setNewOverlayLike(int index, CELOverlay item) {
        return new OverlaysNestedImpl(index, item);
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> editOverlay(int index) {
        if (this.overlays.size() <= index) {
            throw new RuntimeException("Can't edit overlays. Index exceeds size.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> editFirstOverlay() {
        if (this.overlays.size() == 0) {
            throw new RuntimeException("Can't edit first overlays. The list is empty.");
        }
        return this.setNewOverlayLike(0, this.buildOverlay(0));
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> editLastOverlay() {
        int index = this.overlays.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overlays. The list is empty.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    @Override
    public CELInterceptorFluent.OverlaysNested<A> editMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overlays.size(); ++i) {
            if (!predicate.test(this.overlays.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overlays. No match found.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CELInterceptorFluentImpl that = (CELInterceptorFluentImpl)o;
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        return Objects.equals(this.overlays, that.overlays);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.overlays, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter != null) {
            sb.append("filter:");
            sb.append(this.filter + ",");
        }
        if (this.overlays != null) {
            sb.append("overlays:");
            sb.append(this.overlays);
        }
        sb.append("}");
        return sb.toString();
    }

    class OverlaysNestedImpl<N>
    extends CELOverlayFluentImpl<CELInterceptorFluent.OverlaysNested<N>>
    implements CELInterceptorFluent.OverlaysNested<N>,
    Nested<N> {
        CELOverlayBuilder builder;
        int index;

        OverlaysNestedImpl(int index, CELOverlay item) {
            this.index = index;
            this.builder = new CELOverlayBuilder(this, item);
        }

        OverlaysNestedImpl() {
            this.index = -1;
            this.builder = new CELOverlayBuilder(this);
        }

        @Override
        public N and() {
            return (N)CELInterceptorFluentImpl.this.setToOverlays(this.index, this.builder.build());
        }

        @Override
        public N endOverlay() {
            return this.and();
        }
    }
}

