/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.RefSource;
import io.fabric8.tekton.pipeline.v1beta1.RefSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RefSourceFluentImpl<A extends RefSourceFluent<A>>
extends BaseFluent<A>
implements RefSourceFluent<A> {
    private Map<String, String> digest;
    private String entryPoint;
    private String uri;

    public RefSourceFluentImpl() {
    }

    public RefSourceFluentImpl(RefSource instance) {
        if (instance != null) {
            this.withDigest(instance.getDigest());
            this.withEntryPoint(instance.getEntryPoint());
            this.withUri(instance.getUri());
        }
    }

    @Override
    public A addToDigest(String key, String value) {
        if (this.digest == null && key != null && value != null) {
            this.digest = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.digest.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDigest(Map<String, String> map) {
        if (this.digest == null && map != null) {
            this.digest = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.digest.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDigest(String key) {
        if (this.digest == null) {
            return (A)this;
        }
        if (key != null && this.digest != null) {
            this.digest.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDigest(Map<String, String> map) {
        if (this.digest == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.digest == null) continue;
                this.digest.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDigest() {
        return this.digest;
    }

    @Override
    public <K, V> A withDigest(Map<String, String> digest) {
        this.digest = digest == null ? null : new LinkedHashMap<String, String>(digest);
        return (A)this;
    }

    @Override
    public Boolean hasDigest() {
        return this.digest != null;
    }

    @Override
    public String getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public A withEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
        return (A)this;
    }

    @Override
    public Boolean hasEntryPoint() {
        return this.entryPoint != null;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public A withUri(String uri) {
        this.uri = uri;
        return (A)this;
    }

    @Override
    public Boolean hasUri() {
        return this.uri != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RefSourceFluentImpl that = (RefSourceFluentImpl)o;
        if (!Objects.equals(this.digest, that.digest)) {
            return false;
        }
        if (!Objects.equals(this.entryPoint, that.entryPoint)) {
            return false;
        }
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.digest, this.entryPoint, this.uri, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.digest != null && !this.digest.isEmpty()) {
            sb.append("digest:");
            sb.append(this.digest + ",");
        }
        if (this.entryPoint != null) {
            sb.append("entryPoint:");
            sb.append(this.entryPoint + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri);
        }
        sb.append("}");
        return sb.toString();
    }
}

