package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerSpecTemplateBuilder extends TriggerSpecTemplateFluentImpl<TriggerSpecTemplateBuilder> implements VisitableBuilder<TriggerSpecTemplate,TriggerSpecTemplateBuilder>{
  public TriggerSpecTemplateBuilder() {
    this(false);
  }
  public TriggerSpecTemplateBuilder(Boolean validationEnabled) {
    this(new TriggerSpecTemplate(), validationEnabled);
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerSpecTemplate(), validationEnabled);
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,TriggerSpecTemplate instance) {
    this(fluent, instance, false);
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplateFluent<?> fluent,TriggerSpecTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiversion(instance.getApiversion());
      fluent.withRef(instance.getRef());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplate instance) {
    this(instance,false);
  }
  public TriggerSpecTemplateBuilder(TriggerSpecTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiversion(instance.getApiversion());
      this.withRef(instance.getRef());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerSpecTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerSpecTemplate build() {
    TriggerSpecTemplate buildable = new TriggerSpecTemplate(fluent.getApiversion(),fluent.getRef(),fluent.getSpec());
    return buildable;
  }
  
}