package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerInterceptorBuilder extends TriggerInterceptorFluentImpl<TriggerInterceptorBuilder> implements VisitableBuilder<TriggerInterceptor,TriggerInterceptorBuilder>{
  public TriggerInterceptorBuilder() {
    this(false);
  }
  public TriggerInterceptorBuilder(Boolean validationEnabled) {
    this(new TriggerInterceptor(), validationEnabled);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerInterceptor(), validationEnabled);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance) {
    this(fluent, instance, false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptorFluent<?> fluent,TriggerInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBitbucket(instance.getBitbucket());
      fluent.withCel(instance.getCel());
      fluent.withGithub(instance.getGithub());
      fluent.withGitlab(instance.getGitlab());
      fluent.withName(instance.getName());
      fluent.withParams(instance.getParams());
      fluent.withRef(instance.getRef());
      fluent.withWebhook(instance.getWebhook());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerInterceptorBuilder(TriggerInterceptor instance) {
    this(instance,false);
  }
  public TriggerInterceptorBuilder(TriggerInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBitbucket(instance.getBitbucket());
      this.withCel(instance.getCel());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withName(instance.getName());
      this.withParams(instance.getParams());
      this.withRef(instance.getRef());
      this.withWebhook(instance.getWebhook());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerInterceptor build() {
    TriggerInterceptor buildable = new TriggerInterceptor(fluent.getBitbucket(),fluent.getCel(),fluent.getGithub(),fluent.getGitlab(),fluent.getName(),fluent.getParams(),fluent.getRef(),fluent.getWebhook());
    return buildable;
  }
  
}