package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerBindingBuilder extends TriggerBindingFluentImpl<TriggerBindingBuilder> implements VisitableBuilder<TriggerBinding,TriggerBindingBuilder>{
  public TriggerBindingBuilder() {
    this(false);
  }
  public TriggerBindingBuilder(Boolean validationEnabled) {
    this(new TriggerBinding(), validationEnabled);
  }
  public TriggerBindingBuilder(TriggerBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerBinding(), validationEnabled);
  }
  public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,TriggerBinding instance) {
    this(fluent, instance, false);
  }
  public TriggerBindingBuilder(TriggerBindingFluent<?> fluent,TriggerBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerBindingBuilder(TriggerBinding instance) {
    this(instance,false);
  }
  public TriggerBindingBuilder(TriggerBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerBindingFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerBinding build() {
    TriggerBinding buildable = new TriggerBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}