package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretRefBuilder extends SecretRefFluentImpl<SecretRefBuilder> implements VisitableBuilder<SecretRef,SecretRefBuilder>{
  public SecretRefBuilder() {
    this(false);
  }
  public SecretRefBuilder(Boolean validationEnabled) {
    this(new SecretRef(), validationEnabled);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretRef(), validationEnabled);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance) {
    this(fluent, instance, false);
  }
  public SecretRefBuilder(SecretRefFluent<?> fluent,SecretRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSecretKey(instance.getSecretKey());
      fluent.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretRefBuilder(SecretRef instance) {
    this(instance,false);
  }
  public SecretRefBuilder(SecretRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSecretKey(instance.getSecretKey());
      this.withSecretName(instance.getSecretName());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretRefFluent<?> fluent;
  Boolean validationEnabled;
  public SecretRef build() {
    SecretRef buildable = new SecretRef(fluent.getSecretKey(),fluent.getSecretName());
    return buildable;
  }
  
}