package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParamBuilder extends ParamFluentImpl<ParamBuilder> implements VisitableBuilder<Param,ParamBuilder>{
  public ParamBuilder() {
    this(false);
  }
  public ParamBuilder(Boolean validationEnabled) {
    this(new Param(), validationEnabled);
  }
  public ParamBuilder(ParamFluent<?> fluent) {
    this(fluent, false);
  }
  public ParamBuilder(ParamFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Param(), validationEnabled);
  }
  public ParamBuilder(ParamFluent<?> fluent,Param instance) {
    this(fluent, instance, false);
  }
  public ParamBuilder(ParamFluent<?> fluent,Param instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParamBuilder(Param instance) {
    this(instance,false);
  }
  public ParamBuilder(Param instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParamFluent<?> fluent;
  Boolean validationEnabled;
  public Param build() {
    Param buildable = new Param(fluent.getName(),fluent.getValue());
    return buildable;
  }
  
}