package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitLabInterceptorBuilder extends GitLabInterceptorFluentImpl<GitLabInterceptorBuilder> implements VisitableBuilder<GitLabInterceptor,GitLabInterceptorBuilder>{
  public GitLabInterceptorBuilder() {
    this(false);
  }
  public GitLabInterceptorBuilder(Boolean validationEnabled) {
    this(new GitLabInterceptor(), validationEnabled);
  }
  public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitLabInterceptor(), validationEnabled);
  }
  public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,GitLabInterceptor instance) {
    this(fluent, instance, false);
  }
  public GitLabInterceptorBuilder(GitLabInterceptorFluent<?> fluent,GitLabInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEventTypes(instance.getEventTypes());
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitLabInterceptorBuilder(GitLabInterceptor instance) {
    this(instance,false);
  }
  public GitLabInterceptorBuilder(GitLabInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEventTypes(instance.getEventTypes());
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitLabInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public GitLabInterceptor build() {
    GitLabInterceptor buildable = new GitLabInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
    return buildable;
  }
  
}