package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubInterceptorBuilder extends GitHubInterceptorFluentImpl<GitHubInterceptorBuilder> implements VisitableBuilder<GitHubInterceptor,GitHubInterceptorBuilder>{
  public GitHubInterceptorBuilder() {
    this(false);
  }
  public GitHubInterceptorBuilder(Boolean validationEnabled) {
    this(new GitHubInterceptor(), validationEnabled);
  }
  public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GitHubInterceptor(), validationEnabled);
  }
  public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,GitHubInterceptor instance) {
    this(fluent, instance, false);
  }
  public GitHubInterceptorBuilder(GitHubInterceptorFluent<?> fluent,GitHubInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEventTypes(instance.getEventTypes());
      fluent.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GitHubInterceptorBuilder(GitHubInterceptor instance) {
    this(instance,false);
  }
  public GitHubInterceptorBuilder(GitHubInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEventTypes(instance.getEventTypes());
      this.withSecretRef(instance.getSecretRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  GitHubInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public GitHubInterceptor build() {
    GitHubInterceptor buildable = new GitHubInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
    return buildable;
  }
  
}