package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerTriggerBuilder extends EventListenerTriggerFluentImpl<EventListenerTriggerBuilder> implements VisitableBuilder<EventListenerTrigger,EventListenerTriggerBuilder>{
  public EventListenerTriggerBuilder() {
    this(false);
  }
  public EventListenerTriggerBuilder(Boolean validationEnabled) {
    this(new EventListenerTrigger(), validationEnabled);
  }
  public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerTrigger(), validationEnabled);
  }
  public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,EventListenerTrigger instance) {
    this(fluent, instance, false);
  }
  public EventListenerTriggerBuilder(EventListenerTriggerFluent<?> fluent,EventListenerTrigger instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBindings(instance.getBindings());
      fluent.withInterceptors(instance.getInterceptors());
      fluent.withName(instance.getName());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTriggerRef(instance.getTriggerRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerTriggerBuilder(EventListenerTrigger instance) {
    this(instance,false);
  }
  public EventListenerTriggerBuilder(EventListenerTrigger instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBindings(instance.getBindings());
      this.withInterceptors(instance.getInterceptors());
      this.withName(instance.getName());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withTemplate(instance.getTemplate());
      this.withTriggerRef(instance.getTriggerRef());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventListenerTriggerFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerTrigger build() {
    EventListenerTrigger buildable = new EventListenerTrigger(fluent.getBindings(),fluent.getInterceptors(),fluent.getName(),fluent.getServiceAccountName(),fluent.getTemplate(),fluent.getTriggerRef());
    return buildable;
  }
  
}