package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterInterceptorStatusBuilder extends ClusterInterceptorStatusFluentImpl<ClusterInterceptorStatusBuilder> implements VisitableBuilder<ClusterInterceptorStatus,ClusterInterceptorStatusBuilder>{
  public ClusterInterceptorStatusBuilder() {
    this(false);
  }
  public ClusterInterceptorStatusBuilder(Boolean validationEnabled) {
    this(new ClusterInterceptorStatus(), validationEnabled);
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterInterceptorStatus(), validationEnabled);
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatusFluent<?> fluent,ClusterInterceptorStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatusFluent<?> fluent,ClusterInterceptorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatus instance) {
    this(instance,false);
  }
  public ClusterInterceptorStatusBuilder(ClusterInterceptorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterInterceptorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterInterceptorStatus build() {
    ClusterInterceptorStatus buildable = new ClusterInterceptorStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getObservedGeneration());
    return buildable;
  }
  
}