package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterInterceptorSpecBuilder extends ClusterInterceptorSpecFluentImpl<ClusterInterceptorSpecBuilder> implements VisitableBuilder<ClusterInterceptorSpec,ClusterInterceptorSpecBuilder>{
  public ClusterInterceptorSpecBuilder() {
    this(false);
  }
  public ClusterInterceptorSpecBuilder(Boolean validationEnabled) {
    this(new ClusterInterceptorSpec(), validationEnabled);
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterInterceptorSpec(), validationEnabled);
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpecFluent<?> fluent,ClusterInterceptorSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpecFluent<?> fluent,ClusterInterceptorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClientConfig(instance.getClientConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpec instance) {
    this(instance,false);
  }
  public ClusterInterceptorSpecBuilder(ClusterInterceptorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClientConfig(instance.getClientConfig());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterInterceptorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterInterceptorSpec build() {
    ClusterInterceptorSpec buildable = new ClusterInterceptorSpec(fluent.getClientConfig());
    return buildable;
  }
  
}