package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterInterceptorBuilder extends ClusterInterceptorFluentImpl<ClusterInterceptorBuilder> implements VisitableBuilder<ClusterInterceptor,ClusterInterceptorBuilder>{
  public ClusterInterceptorBuilder() {
    this(false);
  }
  public ClusterInterceptorBuilder(Boolean validationEnabled) {
    this(new ClusterInterceptor(), validationEnabled);
  }
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterInterceptor(), validationEnabled);
  }
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent,ClusterInterceptor instance) {
    this(fluent, instance, false);
  }
  public ClusterInterceptorBuilder(ClusterInterceptorFluent<?> fluent,ClusterInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterInterceptorBuilder(ClusterInterceptor instance) {
    this(instance,false);
  }
  public ClusterInterceptorBuilder(ClusterInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterInterceptor build() {
    ClusterInterceptor buildable = new ClusterInterceptor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}