/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.pipeline.v1beta1.PropertySpec;
import io.fabric8.tekton.pipeline.v1beta1.TaskResult;
import io.fabric8.tekton.pipeline.v1beta1.TaskResultFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class TaskResultFluentImpl<A extends TaskResultFluent<A>>
extends BaseFluent<A>
implements TaskResultFluent<A> {
    private String description;
    private String name;
    private Map<String, PropertySpec> properties;
    private String type;

    public TaskResultFluentImpl() {
    }

    public TaskResultFluentImpl(TaskResult instance) {
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withName(instance.getName());
            this.withProperties(instance.getProperties());
            this.withType(instance.getType());
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToProperties(String key, PropertySpec value) {
        if (this.properties == null && key != null && value != null) {
            this.properties = new LinkedHashMap<String, PropertySpec>();
        }
        if (key != null && value != null) {
            this.properties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToProperties(Map<String, PropertySpec> map) {
        if (this.properties == null && map != null) {
            this.properties = new LinkedHashMap<String, PropertySpec>();
        }
        if (map != null) {
            this.properties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(String key) {
        if (this.properties == null) {
            return (A)this;
        }
        if (key != null && this.properties != null) {
            this.properties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromProperties(Map<String, PropertySpec> map) {
        if (this.properties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.properties == null) continue;
                this.properties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, PropertySpec> getProperties() {
        return this.properties;
    }

    @Override
    public <K, V> A withProperties(Map<String, PropertySpec> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, PropertySpec>(properties);
        return (A)this;
    }

    @Override
    public Boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskResultFluentImpl that = (TaskResultFluentImpl)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.properties, this.type, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }
}

