package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookInterceptorBuilder extends WebhookInterceptorFluentImpl<WebhookInterceptorBuilder> implements VisitableBuilder<WebhookInterceptor,WebhookInterceptorBuilder>{
  public WebhookInterceptorBuilder() {
    this(false);
  }
  public WebhookInterceptorBuilder(Boolean validationEnabled) {
    this(new WebhookInterceptor(), validationEnabled);
  }
  public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebhookInterceptor(), validationEnabled);
  }
  public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,WebhookInterceptor instance) {
    this(fluent, instance, false);
  }
  public WebhookInterceptorBuilder(WebhookInterceptorFluent<?> fluent,WebhookInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHeader(instance.getHeader());
      fluent.withObjectRef(instance.getObjectRef());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebhookInterceptorBuilder(WebhookInterceptor instance) {
    this(instance,false);
  }
  public WebhookInterceptorBuilder(WebhookInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHeader(instance.getHeader());
      this.withObjectRef(instance.getObjectRef());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebhookInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public WebhookInterceptor build() {
    WebhookInterceptor buildable = new WebhookInterceptor(fluent.getHeader(),fluent.getObjectRef(),fluent.getUrl());
    return buildable;
  }
  
}