package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerTemplateListBuilder extends TriggerTemplateListFluentImpl<TriggerTemplateListBuilder> implements VisitableBuilder<TriggerTemplateList,TriggerTemplateListBuilder>{
  public TriggerTemplateListBuilder() {
    this(false);
  }
  public TriggerTemplateListBuilder(Boolean validationEnabled) {
    this(new TriggerTemplateList(), validationEnabled);
  }
  public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerTemplateList(), validationEnabled);
  }
  public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,TriggerTemplateList instance) {
    this(fluent, instance, false);
  }
  public TriggerTemplateListBuilder(TriggerTemplateListFluent<?> fluent,TriggerTemplateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerTemplateListBuilder(TriggerTemplateList instance) {
    this(instance,false);
  }
  public TriggerTemplateListBuilder(TriggerTemplateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerTemplateListFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerTemplateList build() {
    TriggerTemplateList buildable = new TriggerTemplateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}