package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>> extends BaseFluent<A> implements TriggerSpecFluent<A>{
  public TriggerSpecFluentImpl() {
  }
  public TriggerSpecFluentImpl(TriggerSpec instance) {
    if (instance != null) {
      this.withBindings(instance.getBindings());
      this.withInterceptors(instance.getInterceptors());
      this.withName(instance.getName());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withTemplate(instance.getTemplate());
    }
  }
  private ArrayList<TriggerSpecBindingBuilder> bindings = new ArrayList<TriggerSpecBindingBuilder>();
  private ArrayList<TriggerInterceptorBuilder> interceptors = new ArrayList<TriggerInterceptorBuilder>();
  private String name;
  private String serviceAccountName;
  private TriggerSpecTemplateBuilder template;
  public A addToBindings(int index,TriggerSpecBinding item) {
    if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
    TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
    if (index < 0 || index >= bindings.size()) { _visitables.get("bindings").add(builder); bindings.add(builder); } else { _visitables.get("bindings").add(index, builder); bindings.add(index, builder);}
    return (A)this;
  }
  public A setToBindings(int index,TriggerSpecBinding item) {
    if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
    TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);
    if (index < 0 || index >= bindings.size()) { _visitables.get("bindings").add(builder); bindings.add(builder); } else { _visitables.get("bindings").set(index, builder); bindings.set(index, builder);}
    return (A)this;
  }
  public A addToBindings(io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBinding... items) {
    if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
    for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").add(builder);this.bindings.add(builder);} return (A)this;
  }
  public A addAllToBindings(Collection<TriggerSpecBinding> items) {
    if (this.bindings == null) {this.bindings = new ArrayList<TriggerSpecBindingBuilder>();}
    for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").add(builder);this.bindings.add(builder);} return (A)this;
  }
  public A removeFromBindings(io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBinding... items) {
    for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").remove(builder);if (this.bindings != null) {this.bindings.remove(builder);}} return (A)this;
  }
  public A removeAllFromBindings(Collection<TriggerSpecBinding> items) {
    for (TriggerSpecBinding item : items) {TriggerSpecBindingBuilder builder = new TriggerSpecBindingBuilder(item);_visitables.get("bindings").remove(builder);if (this.bindings != null) {this.bindings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBindings(Predicate<TriggerSpecBindingBuilder> predicate) {
    if (bindings == null) return (A) this;
    final Iterator<TriggerSpecBindingBuilder> each = bindings.iterator();
    final List visitables = _visitables.get("bindings");
    while (each.hasNext()) {
      TriggerSpecBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBindings instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TriggerSpecBinding> getBindings() {
    return bindings != null ? build(bindings) : null;
  }
  public List<TriggerSpecBinding> buildBindings() {
    return bindings != null ? build(bindings) : null;
  }
  public TriggerSpecBinding buildBinding(int index) {
    return this.bindings.get(index).build();
  }
  public TriggerSpecBinding buildFirstBinding() {
    return this.bindings.get(0).build();
  }
  public TriggerSpecBinding buildLastBinding() {
    return this.bindings.get(bindings.size() - 1).build();
  }
  public TriggerSpecBinding buildMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
    for (TriggerSpecBindingBuilder item: bindings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
    for (TriggerSpecBindingBuilder item: bindings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBindings(List<TriggerSpecBinding> bindings) {
    if (this.bindings != null) { _visitables.get("bindings").clear();}
    if (bindings != null) {this.bindings = new ArrayList(); for (TriggerSpecBinding item : bindings){this.addToBindings(item);}} else { this.bindings = null;} return (A) this;
  }
  public A withBindings(io.fabric8.tekton.triggers.v1alpha1.TriggerSpecBinding... bindings) {
    if (this.bindings != null) {this.bindings.clear(); _visitables.remove("bindings"); }
    if (bindings != null) {for (TriggerSpecBinding item :bindings){ this.addToBindings(item);}} return (A) this;
  }
  public Boolean hasBindings() {
    return bindings != null && !bindings.isEmpty();
  }
  public A addNewBinding(String apiversion,String kind,String name,String ref,String value) {
    return (A)addToBindings(new TriggerSpecBinding(apiversion, kind, name, ref, value));
  }
  public TriggerSpecFluentImpl.BindingsNested<A> addNewBinding() {
    return new TriggerSpecFluentImpl.BindingsNestedImpl();
  }
  public TriggerSpecFluentImpl.BindingsNested<A> addNewBindingLike(TriggerSpecBinding item) {
    return new TriggerSpecFluentImpl.BindingsNestedImpl(-1, item);
  }
  public TriggerSpecFluentImpl.BindingsNested<A> setNewBindingLike(int index,TriggerSpecBinding item) {
    return new TriggerSpecFluentImpl.BindingsNestedImpl(index, item);
  }
  public TriggerSpecFluentImpl.BindingsNested<A> editBinding(int index) {
    if (bindings.size() <= index) throw new RuntimeException("Can't edit bindings. Index exceeds size.");
    return setNewBindingLike(index, buildBinding(index));
  }
  public TriggerSpecFluentImpl.BindingsNested<A> editFirstBinding() {
    if (bindings.size() == 0) throw new RuntimeException("Can't edit first bindings. The list is empty.");
    return setNewBindingLike(0, buildBinding(0));
  }
  public TriggerSpecFluentImpl.BindingsNested<A> editLastBinding() {
    int index = bindings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last bindings. The list is empty.");
    return setNewBindingLike(index, buildBinding(index));
  }
  public TriggerSpecFluentImpl.BindingsNested<A> editMatchingBinding(Predicate<TriggerSpecBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<bindings.size();i++) { 
    if (predicate.test(bindings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching bindings. No match found.");
    return setNewBindingLike(index, buildBinding(index));
  }
  public A addToInterceptors(int index,TriggerInterceptor item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
    if (index < 0 || index >= interceptors.size()) { _visitables.get("interceptors").add(builder); interceptors.add(builder); } else { _visitables.get("interceptors").add(index, builder); interceptors.add(index, builder);}
    return (A)this;
  }
  public A setToInterceptors(int index,TriggerInterceptor item) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);
    if (index < 0 || index >= interceptors.size()) { _visitables.get("interceptors").add(builder); interceptors.add(builder); } else { _visitables.get("interceptors").set(index, builder); interceptors.set(index, builder);}
    return (A)this;
  }
  public A addToInterceptors(io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptor... items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
  }
  public A addAllToInterceptors(Collection<TriggerInterceptor> items) {
    if (this.interceptors == null) {this.interceptors = new ArrayList<TriggerInterceptorBuilder>();}
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").add(builder);this.interceptors.add(builder);} return (A)this;
  }
  public A removeFromInterceptors(io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptor... items) {
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder);if (this.interceptors != null) {this.interceptors.remove(builder);}} return (A)this;
  }
  public A removeAllFromInterceptors(Collection<TriggerInterceptor> items) {
    for (TriggerInterceptor item : items) {TriggerInterceptorBuilder builder = new TriggerInterceptorBuilder(item);_visitables.get("interceptors").remove(builder);if (this.interceptors != null) {this.interceptors.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInterceptors(Predicate<TriggerInterceptorBuilder> predicate) {
    if (interceptors == null) return (A) this;
    final Iterator<TriggerInterceptorBuilder> each = interceptors.iterator();
    final List visitables = _visitables.get("interceptors");
    while (each.hasNext()) {
      TriggerInterceptorBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInterceptors instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TriggerInterceptor> getInterceptors() {
    return interceptors != null ? build(interceptors) : null;
  }
  public List<TriggerInterceptor> buildInterceptors() {
    return interceptors != null ? build(interceptors) : null;
  }
  public TriggerInterceptor buildInterceptor(int index) {
    return this.interceptors.get(index).build();
  }
  public TriggerInterceptor buildFirstInterceptor() {
    return this.interceptors.get(0).build();
  }
  public TriggerInterceptor buildLastInterceptor() {
    return this.interceptors.get(interceptors.size() - 1).build();
  }
  public TriggerInterceptor buildMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
    for (TriggerInterceptorBuilder item: interceptors) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
    for (TriggerInterceptorBuilder item: interceptors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInterceptors(List<TriggerInterceptor> interceptors) {
    if (this.interceptors != null) { _visitables.get("interceptors").clear();}
    if (interceptors != null) {this.interceptors = new ArrayList(); for (TriggerInterceptor item : interceptors){this.addToInterceptors(item);}} else { this.interceptors = null;} return (A) this;
  }
  public A withInterceptors(io.fabric8.tekton.triggers.v1alpha1.TriggerInterceptor... interceptors) {
    if (this.interceptors != null) {this.interceptors.clear(); _visitables.remove("interceptors"); }
    if (interceptors != null) {for (TriggerInterceptor item :interceptors){ this.addToInterceptors(item);}} return (A) this;
  }
  public Boolean hasInterceptors() {
    return interceptors != null && !interceptors.isEmpty();
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> addNewInterceptor() {
    return new TriggerSpecFluentImpl.InterceptorsNestedImpl();
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> addNewInterceptorLike(TriggerInterceptor item) {
    return new TriggerSpecFluentImpl.InterceptorsNestedImpl(-1, item);
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> setNewInterceptorLike(int index,TriggerInterceptor item) {
    return new TriggerSpecFluentImpl.InterceptorsNestedImpl(index, item);
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> editInterceptor(int index) {
    if (interceptors.size() <= index) throw new RuntimeException("Can't edit interceptors. Index exceeds size.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> editFirstInterceptor() {
    if (interceptors.size() == 0) throw new RuntimeException("Can't edit first interceptors. The list is empty.");
    return setNewInterceptorLike(0, buildInterceptor(0));
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> editLastInterceptor() {
    int index = interceptors.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last interceptors. The list is empty.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  public TriggerSpecFluentImpl.InterceptorsNested<A> editMatchingInterceptor(Predicate<TriggerInterceptorBuilder> predicate) {
    int index = -1;
    for (int i=0;i<interceptors.size();i++) { 
    if (predicate.test(interceptors.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching interceptors. No match found.");
    return setNewInterceptorLike(index, buildInterceptor(index));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public TriggerSpecTemplate getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public TriggerSpecTemplate buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(TriggerSpecTemplate template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new TriggerSpecTemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public TriggerSpecFluentImpl.TemplateNested<A> withNewTemplate() {
    return new TriggerSpecFluentImpl.TemplateNestedImpl();
  }
  public TriggerSpecFluentImpl.TemplateNested<A> withNewTemplateLike(TriggerSpecTemplate item) {
    return new TriggerSpecFluentImpl.TemplateNestedImpl(item);
  }
  public TriggerSpecFluentImpl.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public TriggerSpecFluentImpl.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new TriggerSpecTemplateBuilder().build());
  }
  public TriggerSpecFluentImpl.TemplateNested<A> editOrNewTemplateLike(TriggerSpecTemplate item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerSpecFluentImpl that = (TriggerSpecFluentImpl) o;
    if (!java.util.Objects.equals(bindings, that.bindings)) return false;

    if (!java.util.Objects.equals(interceptors, that.interceptors)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bindings,  interceptors,  name,  serviceAccountName,  template,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindings != null) { sb.append("bindings:"); sb.append(bindings + ","); }
    if (interceptors != null) { sb.append("interceptors:"); sb.append(interceptors + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (template != null) { sb.append("template:"); sb.append(template); }
    sb.append("}");
    return sb.toString();
  }
  class BindingsNestedImpl<N> extends TriggerSpecBindingFluentImpl<TriggerSpecFluentImpl.BindingsNested<N>> implements TriggerSpecFluentImpl.BindingsNested<N>,Nested<N>{
    BindingsNestedImpl(int index,TriggerSpecBinding item) {
      this.index = index;
      this.builder = new TriggerSpecBindingBuilder(this, item);
    }
    BindingsNestedImpl() {
      this.index = -1;
      this.builder = new TriggerSpecBindingBuilder(this);
    }
    TriggerSpecBindingBuilder builder;
    int index;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.setToBindings(index,builder.build());
    }
    public N endBinding() {
      return and();
    }
    
  }
  class InterceptorsNestedImpl<N> extends TriggerInterceptorFluentImpl<TriggerSpecFluentImpl.InterceptorsNested<N>> implements TriggerSpecFluentImpl.InterceptorsNested<N>,Nested<N>{
    InterceptorsNestedImpl(int index,TriggerInterceptor item) {
      this.index = index;
      this.builder = new TriggerInterceptorBuilder(this, item);
    }
    InterceptorsNestedImpl() {
      this.index = -1;
      this.builder = new TriggerInterceptorBuilder(this);
    }
    TriggerInterceptorBuilder builder;
    int index;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.setToInterceptors(index,builder.build());
    }
    public N endInterceptor() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends TriggerSpecTemplateFluentImpl<TriggerSpecFluentImpl.TemplateNested<N>> implements TriggerSpecFluentImpl.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(TriggerSpecTemplate item) {
      this.builder = new TriggerSpecTemplateBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new TriggerSpecTemplateBuilder(this);
    }
    TriggerSpecTemplateBuilder builder;
    public N and() {
      return (N) TriggerSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}