package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerSpecBuilder extends TriggerSpecFluentImpl<TriggerSpecBuilder> implements VisitableBuilder<TriggerSpec,TriggerSpecBuilder>{
  public TriggerSpecBuilder() {
    this(false);
  }
  public TriggerSpecBuilder(Boolean validationEnabled) {
    this(new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerSpec(), validationEnabled);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance) {
    this(fluent, instance, false);
  }
  public TriggerSpecBuilder(TriggerSpecFluent<?> fluent,TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBindings(instance.getBindings());
      fluent.withInterceptors(instance.getInterceptors());
      fluent.withName(instance.getName());
      fluent.withServiceAccountName(instance.getServiceAccountName());
      fluent.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerSpecBuilder(TriggerSpec instance) {
    this(instance,false);
  }
  public TriggerSpecBuilder(TriggerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBindings(instance.getBindings());
      this.withInterceptors(instance.getInterceptors());
      this.withName(instance.getName());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withTemplate(instance.getTemplate());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerSpec build() {
    TriggerSpec buildable = new TriggerSpec(fluent.getBindings(),fluent.getInterceptors(),fluent.getName(),fluent.getServiceAccountName(),fluent.getTemplate());
    return buildable;
  }
  
}