package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TriggerInterceptorFluentImpl<A extends TriggerInterceptorFluent<A>> extends BaseFluent<A> implements TriggerInterceptorFluent<A>{
  public TriggerInterceptorFluentImpl() {
  }
  public TriggerInterceptorFluentImpl(TriggerInterceptor instance) {
    if (instance != null) {
      this.withBitbucket(instance.getBitbucket());
      this.withCel(instance.getCel());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withName(instance.getName());
      this.withParams(instance.getParams());
      this.withRef(instance.getRef());
      this.withWebhook(instance.getWebhook());
    }
  }
  private BitbucketInterceptorBuilder bitbucket;
  private CELInterceptorBuilder cel;
  private GitHubInterceptorBuilder github;
  private GitLabInterceptorBuilder gitlab;
  private String name;
  private ArrayList<InterceptorParamsBuilder> params = new ArrayList<InterceptorParamsBuilder>();
  private InterceptorRefBuilder ref;
  private WebhookInterceptorBuilder webhook;
  
  /**
   * This method has been deprecated, please use method buildBitbucket instead.
   * @return The buildable object.
   */
  @Deprecated
  public BitbucketInterceptor getBitbucket() {
    return this.bitbucket!=null ?this.bitbucket.build():null;
  }
  public BitbucketInterceptor buildBitbucket() {
    return this.bitbucket!=null ?this.bitbucket.build():null;
  }
  public A withBitbucket(BitbucketInterceptor bitbucket) {
    _visitables.get("bitbucket").remove(this.bitbucket);
    if (bitbucket!=null){ this.bitbucket= new BitbucketInterceptorBuilder(bitbucket); _visitables.get("bitbucket").add(this.bitbucket);} else { this.bitbucket = null; _visitables.get("bitbucket").remove(this.bitbucket); } return (A) this;
  }
  public Boolean hasBitbucket() {
    return this.bitbucket != null;
  }
  public TriggerInterceptorFluentImpl.BitbucketNested<A> withNewBitbucket() {
    return new TriggerInterceptorFluentImpl.BitbucketNestedImpl();
  }
  public TriggerInterceptorFluentImpl.BitbucketNested<A> withNewBitbucketLike(BitbucketInterceptor item) {
    return new TriggerInterceptorFluentImpl.BitbucketNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.BitbucketNested<A> editBitbucket() {
    return withNewBitbucketLike(getBitbucket());
  }
  public TriggerInterceptorFluentImpl.BitbucketNested<A> editOrNewBitbucket() {
    return withNewBitbucketLike(getBitbucket() != null ? getBitbucket(): new BitbucketInterceptorBuilder().build());
  }
  public TriggerInterceptorFluentImpl.BitbucketNested<A> editOrNewBitbucketLike(BitbucketInterceptor item) {
    return withNewBitbucketLike(getBitbucket() != null ? getBitbucket(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCel instead.
   * @return The buildable object.
   */
  @Deprecated
  public CELInterceptor getCel() {
    return this.cel!=null ?this.cel.build():null;
  }
  public CELInterceptor buildCel() {
    return this.cel!=null ?this.cel.build():null;
  }
  public A withCel(CELInterceptor cel) {
    _visitables.get("cel").remove(this.cel);
    if (cel!=null){ this.cel= new CELInterceptorBuilder(cel); _visitables.get("cel").add(this.cel);} else { this.cel = null; _visitables.get("cel").remove(this.cel); } return (A) this;
  }
  public Boolean hasCel() {
    return this.cel != null;
  }
  public TriggerInterceptorFluentImpl.CelNested<A> withNewCel() {
    return new TriggerInterceptorFluentImpl.CelNestedImpl();
  }
  public TriggerInterceptorFluentImpl.CelNested<A> withNewCelLike(CELInterceptor item) {
    return new TriggerInterceptorFluentImpl.CelNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.CelNested<A> editCel() {
    return withNewCelLike(getCel());
  }
  public TriggerInterceptorFluentImpl.CelNested<A> editOrNewCel() {
    return withNewCelLike(getCel() != null ? getCel(): new CELInterceptorBuilder().build());
  }
  public TriggerInterceptorFluentImpl.CelNested<A> editOrNewCelLike(CELInterceptor item) {
    return withNewCelLike(getCel() != null ? getCel(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGithub instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitHubInterceptor getGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public GitHubInterceptor buildGithub() {
    return this.github!=null ?this.github.build():null;
  }
  public A withGithub(GitHubInterceptor github) {
    _visitables.get("github").remove(this.github);
    if (github!=null){ this.github= new GitHubInterceptorBuilder(github); _visitables.get("github").add(this.github);} else { this.github = null; _visitables.get("github").remove(this.github); } return (A) this;
  }
  public Boolean hasGithub() {
    return this.github != null;
  }
  public TriggerInterceptorFluentImpl.GithubNested<A> withNewGithub() {
    return new TriggerInterceptorFluentImpl.GithubNestedImpl();
  }
  public TriggerInterceptorFluentImpl.GithubNested<A> withNewGithubLike(GitHubInterceptor item) {
    return new TriggerInterceptorFluentImpl.GithubNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.GithubNested<A> editGithub() {
    return withNewGithubLike(getGithub());
  }
  public TriggerInterceptorFluentImpl.GithubNested<A> editOrNewGithub() {
    return withNewGithubLike(getGithub() != null ? getGithub(): new GitHubInterceptorBuilder().build());
  }
  public TriggerInterceptorFluentImpl.GithubNested<A> editOrNewGithubLike(GitHubInterceptor item) {
    return withNewGithubLike(getGithub() != null ? getGithub(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGitlab instead.
   * @return The buildable object.
   */
  @Deprecated
  public GitLabInterceptor getGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public GitLabInterceptor buildGitlab() {
    return this.gitlab!=null ?this.gitlab.build():null;
  }
  public A withGitlab(GitLabInterceptor gitlab) {
    _visitables.get("gitlab").remove(this.gitlab);
    if (gitlab!=null){ this.gitlab= new GitLabInterceptorBuilder(gitlab); _visitables.get("gitlab").add(this.gitlab);} else { this.gitlab = null; _visitables.get("gitlab").remove(this.gitlab); } return (A) this;
  }
  public Boolean hasGitlab() {
    return this.gitlab != null;
  }
  public TriggerInterceptorFluentImpl.GitlabNested<A> withNewGitlab() {
    return new TriggerInterceptorFluentImpl.GitlabNestedImpl();
  }
  public TriggerInterceptorFluentImpl.GitlabNested<A> withNewGitlabLike(GitLabInterceptor item) {
    return new TriggerInterceptorFluentImpl.GitlabNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.GitlabNested<A> editGitlab() {
    return withNewGitlabLike(getGitlab());
  }
  public TriggerInterceptorFluentImpl.GitlabNested<A> editOrNewGitlab() {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): new GitLabInterceptorBuilder().build());
  }
  public TriggerInterceptorFluentImpl.GitlabNested<A> editOrNewGitlabLike(GitLabInterceptor item) {
    return withNewGitlabLike(getGitlab() != null ? getGitlab(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToParams(int index,InterceptorParams item) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  public A setToParams(int index,InterceptorParams item) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  public A addToParams(io.fabric8.tekton.triggers.v1alpha1.InterceptorParams... items) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A addAllToParams(Collection<InterceptorParams> items) {
    if (this.params == null) {this.params = new ArrayList<InterceptorParamsBuilder>();}
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  public A removeFromParams(io.fabric8.tekton.triggers.v1alpha1.InterceptorParams... items) {
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeAllFromParams(Collection<InterceptorParams> items) {
    for (InterceptorParams item : items) {InterceptorParamsBuilder builder = new InterceptorParamsBuilder(item);_visitables.get("params").remove(builder);if (this.params != null) {this.params.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParams(Predicate<InterceptorParamsBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<InterceptorParamsBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      InterceptorParamsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParams instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<InterceptorParams> getParams() {
    return params != null ? build(params) : null;
  }
  public List<InterceptorParams> buildParams() {
    return params != null ? build(params) : null;
  }
  public InterceptorParams buildParam(int index) {
    return this.params.get(index).build();
  }
  public InterceptorParams buildFirstParam() {
    return this.params.get(0).build();
  }
  public InterceptorParams buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  public InterceptorParams buildMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
    for (InterceptorParamsBuilder item: params) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
    for (InterceptorParamsBuilder item: params) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParams(List<InterceptorParams> params) {
    if (this.params != null) { _visitables.get("params").clear();}
    if (params != null) {this.params = new ArrayList(); for (InterceptorParams item : params){this.addToParams(item);}} else { this.params = null;} return (A) this;
  }
  public A withParams(io.fabric8.tekton.triggers.v1alpha1.InterceptorParams... params) {
    if (this.params != null) {this.params.clear(); _visitables.remove("params"); }
    if (params != null) {for (InterceptorParams item :params){ this.addToParams(item);}} return (A) this;
  }
  public Boolean hasParams() {
    return params != null && !params.isEmpty();
  }
  public A addNewParam(String name,Object value) {
    return (A)addToParams(new InterceptorParams(name, value));
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> addNewParam() {
    return new TriggerInterceptorFluentImpl.ParamsNestedImpl();
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> addNewParamLike(InterceptorParams item) {
    return new TriggerInterceptorFluentImpl.ParamsNestedImpl(-1, item);
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> setNewParamLike(int index,InterceptorParams item) {
    return new TriggerInterceptorFluentImpl.ParamsNestedImpl(index, item);
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  public TriggerInterceptorFluentImpl.ParamsNested<A> editMatchingParam(Predicate<InterceptorParamsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  /**
   * This method has been deprecated, please use method buildRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public InterceptorRef getRef() {
    return this.ref!=null ?this.ref.build():null;
  }
  public InterceptorRef buildRef() {
    return this.ref!=null ?this.ref.build():null;
  }
  public A withRef(InterceptorRef ref) {
    _visitables.get("ref").remove(this.ref);
    if (ref!=null){ this.ref= new InterceptorRefBuilder(ref); _visitables.get("ref").add(this.ref);} else { this.ref = null; _visitables.get("ref").remove(this.ref); } return (A) this;
  }
  public Boolean hasRef() {
    return this.ref != null;
  }
  public A withNewRef(String apiVersion,String kind,String name) {
    return (A)withRef(new InterceptorRef(apiVersion, kind, name));
  }
  public TriggerInterceptorFluentImpl.RefNested<A> withNewRef() {
    return new TriggerInterceptorFluentImpl.RefNestedImpl();
  }
  public TriggerInterceptorFluentImpl.RefNested<A> withNewRefLike(InterceptorRef item) {
    return new TriggerInterceptorFluentImpl.RefNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.RefNested<A> editRef() {
    return withNewRefLike(getRef());
  }
  public TriggerInterceptorFluentImpl.RefNested<A> editOrNewRef() {
    return withNewRefLike(getRef() != null ? getRef(): new InterceptorRefBuilder().build());
  }
  public TriggerInterceptorFluentImpl.RefNested<A> editOrNewRefLike(InterceptorRef item) {
    return withNewRefLike(getRef() != null ? getRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildWebhook instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebhookInterceptor getWebhook() {
    return this.webhook!=null ?this.webhook.build():null;
  }
  public WebhookInterceptor buildWebhook() {
    return this.webhook!=null ?this.webhook.build():null;
  }
  public A withWebhook(WebhookInterceptor webhook) {
    _visitables.get("webhook").remove(this.webhook);
    if (webhook!=null){ this.webhook= new WebhookInterceptorBuilder(webhook); _visitables.get("webhook").add(this.webhook);} else { this.webhook = null; _visitables.get("webhook").remove(this.webhook); } return (A) this;
  }
  public Boolean hasWebhook() {
    return this.webhook != null;
  }
  public TriggerInterceptorFluentImpl.WebhookNested<A> withNewWebhook() {
    return new TriggerInterceptorFluentImpl.WebhookNestedImpl();
  }
  public TriggerInterceptorFluentImpl.WebhookNested<A> withNewWebhookLike(WebhookInterceptor item) {
    return new TriggerInterceptorFluentImpl.WebhookNestedImpl(item);
  }
  public TriggerInterceptorFluentImpl.WebhookNested<A> editWebhook() {
    return withNewWebhookLike(getWebhook());
  }
  public TriggerInterceptorFluentImpl.WebhookNested<A> editOrNewWebhook() {
    return withNewWebhookLike(getWebhook() != null ? getWebhook(): new WebhookInterceptorBuilder().build());
  }
  public TriggerInterceptorFluentImpl.WebhookNested<A> editOrNewWebhookLike(WebhookInterceptor item) {
    return withNewWebhookLike(getWebhook() != null ? getWebhook(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerInterceptorFluentImpl that = (TriggerInterceptorFluentImpl) o;
    if (!java.util.Objects.equals(bitbucket, that.bitbucket)) return false;

    if (!java.util.Objects.equals(cel, that.cel)) return false;

    if (!java.util.Objects.equals(github, that.github)) return false;

    if (!java.util.Objects.equals(gitlab, that.gitlab)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(params, that.params)) return false;

    if (!java.util.Objects.equals(ref, that.ref)) return false;

    if (!java.util.Objects.equals(webhook, that.webhook)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bitbucket,  cel,  github,  gitlab,  name,  params,  ref,  webhook,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bitbucket != null) { sb.append("bitbucket:"); sb.append(bitbucket + ","); }
    if (cel != null) { sb.append("cel:"); sb.append(cel + ","); }
    if (github != null) { sb.append("github:"); sb.append(github + ","); }
    if (gitlab != null) { sb.append("gitlab:"); sb.append(gitlab + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (params != null) { sb.append("params:"); sb.append(params + ","); }
    if (ref != null) { sb.append("ref:"); sb.append(ref + ","); }
    if (webhook != null) { sb.append("webhook:"); sb.append(webhook); }
    sb.append("}");
    return sb.toString();
  }
  class BitbucketNestedImpl<N> extends BitbucketInterceptorFluentImpl<TriggerInterceptorFluentImpl.BitbucketNested<N>> implements TriggerInterceptorFluentImpl.BitbucketNested<N>,Nested<N>{
    BitbucketNestedImpl(BitbucketInterceptor item) {
      this.builder = new BitbucketInterceptorBuilder(this, item);
    }
    BitbucketNestedImpl() {
      this.builder = new BitbucketInterceptorBuilder(this);
    }
    BitbucketInterceptorBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withBitbucket(builder.build());
    }
    public N endBitbucket() {
      return and();
    }
    
  }
  class CelNestedImpl<N> extends CELInterceptorFluentImpl<TriggerInterceptorFluentImpl.CelNested<N>> implements TriggerInterceptorFluentImpl.CelNested<N>,Nested<N>{
    CelNestedImpl(CELInterceptor item) {
      this.builder = new CELInterceptorBuilder(this, item);
    }
    CelNestedImpl() {
      this.builder = new CELInterceptorBuilder(this);
    }
    CELInterceptorBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withCel(builder.build());
    }
    public N endCel() {
      return and();
    }
    
  }
  class GithubNestedImpl<N> extends GitHubInterceptorFluentImpl<TriggerInterceptorFluentImpl.GithubNested<N>> implements TriggerInterceptorFluentImpl.GithubNested<N>,Nested<N>{
    GithubNestedImpl(GitHubInterceptor item) {
      this.builder = new GitHubInterceptorBuilder(this, item);
    }
    GithubNestedImpl() {
      this.builder = new GitHubInterceptorBuilder(this);
    }
    GitHubInterceptorBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withGithub(builder.build());
    }
    public N endGithub() {
      return and();
    }
    
  }
  class GitlabNestedImpl<N> extends GitLabInterceptorFluentImpl<TriggerInterceptorFluentImpl.GitlabNested<N>> implements TriggerInterceptorFluentImpl.GitlabNested<N>,Nested<N>{
    GitlabNestedImpl(GitLabInterceptor item) {
      this.builder = new GitLabInterceptorBuilder(this, item);
    }
    GitlabNestedImpl() {
      this.builder = new GitLabInterceptorBuilder(this);
    }
    GitLabInterceptorBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withGitlab(builder.build());
    }
    public N endGitlab() {
      return and();
    }
    
  }
  class ParamsNestedImpl<N> extends InterceptorParamsFluentImpl<TriggerInterceptorFluentImpl.ParamsNested<N>> implements TriggerInterceptorFluentImpl.ParamsNested<N>,Nested<N>{
    ParamsNestedImpl(int index,InterceptorParams item) {
      this.index = index;
      this.builder = new InterceptorParamsBuilder(this, item);
    }
    ParamsNestedImpl() {
      this.index = -1;
      this.builder = new InterceptorParamsBuilder(this);
    }
    InterceptorParamsBuilder builder;
    int index;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.setToParams(index,builder.build());
    }
    public N endParam() {
      return and();
    }
    
  }
  class RefNestedImpl<N> extends InterceptorRefFluentImpl<TriggerInterceptorFluentImpl.RefNested<N>> implements TriggerInterceptorFluentImpl.RefNested<N>,Nested<N>{
    RefNestedImpl(InterceptorRef item) {
      this.builder = new InterceptorRefBuilder(this, item);
    }
    RefNestedImpl() {
      this.builder = new InterceptorRefBuilder(this);
    }
    InterceptorRefBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withRef(builder.build());
    }
    public N endRef() {
      return and();
    }
    
  }
  class WebhookNestedImpl<N> extends WebhookInterceptorFluentImpl<TriggerInterceptorFluentImpl.WebhookNested<N>> implements TriggerInterceptorFluentImpl.WebhookNested<N>,Nested<N>{
    WebhookNestedImpl(WebhookInterceptor item) {
      this.builder = new WebhookInterceptorBuilder(this, item);
    }
    WebhookNestedImpl() {
      this.builder = new WebhookInterceptorBuilder(this);
    }
    WebhookInterceptorBuilder builder;
    public N and() {
      return (N) TriggerInterceptorFluentImpl.this.withWebhook(builder.build());
    }
    public N endWebhook() {
      return and();
    }
    
  }
  
}