package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerBindingListBuilder extends TriggerBindingListFluentImpl<TriggerBindingListBuilder> implements VisitableBuilder<TriggerBindingList,TriggerBindingListBuilder>{
  public TriggerBindingListBuilder() {
    this(false);
  }
  public TriggerBindingListBuilder(Boolean validationEnabled) {
    this(new TriggerBindingList(), validationEnabled);
  }
  public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerBindingList(), validationEnabled);
  }
  public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,TriggerBindingList instance) {
    this(fluent, instance, false);
  }
  public TriggerBindingListBuilder(TriggerBindingListFluent<?> fluent,TriggerBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TriggerBindingListBuilder(TriggerBindingList instance) {
    this(instance,false);
  }
  public TriggerBindingListBuilder(TriggerBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  TriggerBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerBindingList build() {
    TriggerBindingList buildable = new TriggerBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}