package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1.WithPodSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1.WithPodSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1.WithPodSpecFluentImpl;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubernetesResourceFluentImpl<A extends KubernetesResourceFluent<A>> extends BaseFluent<A> implements KubernetesResourceFluent<A>{
  public KubernetesResourceFluentImpl() {
  }
  public KubernetesResourceFluentImpl(KubernetesResource instance) {
    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withServiceType(instance.getServiceType());
      this.withSpec(instance.getSpec());
    }
  }
  private Integer replicas;
  private String serviceType;
  private WithPodSpecBuilder spec;
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public String getServiceType() {
    return this.serviceType;
  }
  public A withServiceType(String serviceType) {
    this.serviceType=serviceType; return (A) this;
  }
  public Boolean hasServiceType() {
    return this.serviceType != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public WithPodSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public WithPodSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(WithPodSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new WithPodSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public KubernetesResourceFluentImpl.SpecNested<A> withNewSpec() {
    return new KubernetesResourceFluentImpl.SpecNestedImpl();
  }
  public KubernetesResourceFluentImpl.SpecNested<A> withNewSpecLike(WithPodSpec item) {
    return new KubernetesResourceFluentImpl.SpecNestedImpl(item);
  }
  public KubernetesResourceFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public KubernetesResourceFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new WithPodSpecBuilder().build());
  }
  public KubernetesResourceFluentImpl.SpecNested<A> editOrNewSpecLike(WithPodSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesResourceFluentImpl that = (KubernetesResourceFluentImpl) o;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(serviceType, that.serviceType)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(replicas,  serviceType,  spec,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (serviceType != null) { sb.append("serviceType:"); sb.append(serviceType + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec); }
    sb.append("}");
    return sb.toString();
  }
  class SpecNestedImpl<N> extends WithPodSpecFluentImpl<KubernetesResourceFluentImpl.SpecNested<N>> implements KubernetesResourceFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(WithPodSpec item) {
      this.builder = new WithPodSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new WithPodSpecBuilder(this);
    }
    WithPodSpecBuilder builder;
    public N and() {
      return (N) KubernetesResourceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}