package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubernetesResourceBuilder extends KubernetesResourceFluentImpl<KubernetesResourceBuilder> implements VisitableBuilder<KubernetesResource,KubernetesResourceBuilder>{
  public KubernetesResourceBuilder() {
    this(false);
  }
  public KubernetesResourceBuilder(Boolean validationEnabled) {
    this(new KubernetesResource(), validationEnabled);
  }
  public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubernetesResource(), validationEnabled);
  }
  public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent,KubernetesResource instance) {
    this(fluent, instance, false);
  }
  public KubernetesResourceBuilder(KubernetesResourceFluent<?> fluent,KubernetesResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withServiceType(instance.getServiceType());
      fluent.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubernetesResourceBuilder(KubernetesResource instance) {
    this(instance,false);
  }
  public KubernetesResourceBuilder(KubernetesResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withServiceType(instance.getServiceType());
      this.withSpec(instance.getSpec());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubernetesResourceFluent<?> fluent;
  Boolean validationEnabled;
  public KubernetesResource build() {
    KubernetesResource buildable = new KubernetesResource(fluent.getReplicas(),fluent.getServiceType(),fluent.getSpec());
    return buildable;
  }
  
}