package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InterceptorRefBuilder extends InterceptorRefFluentImpl<InterceptorRefBuilder> implements VisitableBuilder<InterceptorRef,InterceptorRefBuilder>{
  public InterceptorRefBuilder() {
    this(false);
  }
  public InterceptorRefBuilder(Boolean validationEnabled) {
    this(new InterceptorRef(), validationEnabled);
  }
  public InterceptorRefBuilder(InterceptorRefFluent<?> fluent) {
    this(fluent, false);
  }
  public InterceptorRefBuilder(InterceptorRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InterceptorRef(), validationEnabled);
  }
  public InterceptorRefBuilder(InterceptorRefFluent<?> fluent,InterceptorRef instance) {
    this(fluent, instance, false);
  }
  public InterceptorRefBuilder(InterceptorRefFluent<?> fluent,InterceptorRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InterceptorRefBuilder(InterceptorRef instance) {
    this(instance,false);
  }
  public InterceptorRefBuilder(InterceptorRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  InterceptorRefFluent<?> fluent;
  Boolean validationEnabled;
  public InterceptorRef build() {
    InterceptorRef buildable = new InterceptorRef(fluent.getApiVersion(),fluent.getKind(),fluent.getName());
    return buildable;
  }
  
}