package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InterceptorParamsBuilder extends InterceptorParamsFluentImpl<InterceptorParamsBuilder> implements VisitableBuilder<InterceptorParams,InterceptorParamsBuilder>{
  public InterceptorParamsBuilder() {
    this(false);
  }
  public InterceptorParamsBuilder(Boolean validationEnabled) {
    this(new InterceptorParams(), validationEnabled);
  }
  public InterceptorParamsBuilder(InterceptorParamsFluent<?> fluent) {
    this(fluent, false);
  }
  public InterceptorParamsBuilder(InterceptorParamsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InterceptorParams(), validationEnabled);
  }
  public InterceptorParamsBuilder(InterceptorParamsFluent<?> fluent,InterceptorParams instance) {
    this(fluent, instance, false);
  }
  public InterceptorParamsBuilder(InterceptorParamsFluent<?> fluent,InterceptorParams instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InterceptorParamsBuilder(InterceptorParams instance) {
    this(instance,false);
  }
  public InterceptorParamsBuilder(InterceptorParams instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  InterceptorParamsFluent<?> fluent;
  Boolean validationEnabled;
  public InterceptorParams build() {
    InterceptorParams buildable = new InterceptorParams(fluent.getName(),fluent.getValue());
    return buildable;
  }
  
}