package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InterceptorListBuilder extends InterceptorListFluentImpl<InterceptorListBuilder> implements VisitableBuilder<InterceptorList,InterceptorListBuilder>{
  public InterceptorListBuilder() {
    this(false);
  }
  public InterceptorListBuilder(Boolean validationEnabled) {
    this(new InterceptorList(), validationEnabled);
  }
  public InterceptorListBuilder(InterceptorListFluent<?> fluent) {
    this(fluent, false);
  }
  public InterceptorListBuilder(InterceptorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InterceptorList(), validationEnabled);
  }
  public InterceptorListBuilder(InterceptorListFluent<?> fluent,InterceptorList instance) {
    this(fluent, instance, false);
  }
  public InterceptorListBuilder(InterceptorListFluent<?> fluent,InterceptorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InterceptorListBuilder(InterceptorList instance) {
    this(instance,false);
  }
  public InterceptorListBuilder(InterceptorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  InterceptorListFluent<?> fluent;
  Boolean validationEnabled;
  public InterceptorList build() {
    InterceptorList buildable = new InterceptorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}