package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InterceptorFluentImpl<A extends InterceptorFluent<A>> extends BaseFluent<A> implements InterceptorFluent<A>{
  public InterceptorFluentImpl() {
  }
  public InterceptorFluentImpl(Interceptor instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private InterceptorSpecBuilder spec;
  private InterceptorStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public InterceptorFluentImpl.MetadataNested<A> withNewMetadata() {
    return new InterceptorFluentImpl.MetadataNestedImpl();
  }
  public InterceptorFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new InterceptorFluentImpl.MetadataNestedImpl(item);
  }
  public InterceptorFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public InterceptorFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public InterceptorFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public InterceptorSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public InterceptorSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(InterceptorSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new InterceptorSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public InterceptorFluentImpl.SpecNested<A> withNewSpec() {
    return new InterceptorFluentImpl.SpecNestedImpl();
  }
  public InterceptorFluentImpl.SpecNested<A> withNewSpecLike(InterceptorSpec item) {
    return new InterceptorFluentImpl.SpecNestedImpl(item);
  }
  public InterceptorFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public InterceptorFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new InterceptorSpecBuilder().build());
  }
  public InterceptorFluentImpl.SpecNested<A> editOrNewSpecLike(InterceptorSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public InterceptorStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public InterceptorStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(InterceptorStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new InterceptorStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public InterceptorFluentImpl.StatusNested<A> withNewStatus() {
    return new InterceptorFluentImpl.StatusNestedImpl();
  }
  public InterceptorFluentImpl.StatusNested<A> withNewStatusLike(InterceptorStatus item) {
    return new InterceptorFluentImpl.StatusNestedImpl(item);
  }
  public InterceptorFluentImpl.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public InterceptorFluentImpl.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new InterceptorStatusBuilder().build());
  }
  public InterceptorFluentImpl.StatusNested<A> editOrNewStatusLike(InterceptorStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InterceptorFluentImpl that = (InterceptorFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<InterceptorFluentImpl.MetadataNested<N>> implements InterceptorFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) InterceptorFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends InterceptorSpecFluentImpl<InterceptorFluentImpl.SpecNested<N>> implements InterceptorFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(InterceptorSpec item) {
      this.builder = new InterceptorSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new InterceptorSpecBuilder(this);
    }
    InterceptorSpecBuilder builder;
    public N and() {
      return (N) InterceptorFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends InterceptorStatusFluentImpl<InterceptorFluentImpl.StatusNested<N>> implements InterceptorFluentImpl.StatusNested<N>,Nested<N>{
    StatusNestedImpl(InterceptorStatus item) {
      this.builder = new InterceptorStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new InterceptorStatusBuilder(this);
    }
    InterceptorStatusBuilder builder;
    public N and() {
      return (N) InterceptorFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}