package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerStatusBuilder extends EventListenerStatusFluentImpl<EventListenerStatusBuilder> implements VisitableBuilder<EventListenerStatus,EventListenerStatusBuilder>{
  public EventListenerStatusBuilder() {
    this(false);
  }
  public EventListenerStatusBuilder(Boolean validationEnabled) {
    this(new EventListenerStatus(), validationEnabled);
  }
  public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerStatus(), validationEnabled);
  }
  public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,EventListenerStatus instance) {
    this(fluent, instance, false);
  }
  public EventListenerStatusBuilder(EventListenerStatusFluent<?> fluent,EventListenerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withConditions(instance.getConditions());
      fluent.withConfiguration(instance.getConfiguration());
      fluent.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerStatusBuilder(EventListenerStatus instance) {
    this(instance,false);
  }
  public EventListenerStatusBuilder(EventListenerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withAnnotations(instance.getAnnotations());
      this.withConditions(instance.getConditions());
      this.withConfiguration(instance.getConfiguration());
      this.withObservedGeneration(instance.getObservedGeneration());
    }
    this.validationEnabled = validationEnabled; 
  }
  EventListenerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerStatus build() {
    EventListenerStatus buildable = new EventListenerStatus(fluent.getAddress(),fluent.getAnnotations(),fluent.getConditions(),fluent.getConfiguration(),fluent.getObservedGeneration());
    return buildable;
  }
  
}