package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventListenerSpecFluentImpl<A extends EventListenerSpecFluent<A>> extends BaseFluent<A> implements EventListenerSpecFluent<A>{
  public EventListenerSpecFluentImpl() {
  }
  public EventListenerSpecFluentImpl(EventListenerSpec instance) {
    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withResources(instance.getResources());
      this.withServiceAccountName(instance.getServiceAccountName());
      this.withTriggers(instance.getTriggers());
    }
  }
  private LabelSelectorBuilder labelSelector;
  private NamespaceSelectorBuilder namespaceSelector;
  private ResourcesBuilder resources;
  private String serviceAccountName;
  private ArrayList<EventListenerTriggerBuilder> triggers = new ArrayList<EventListenerTriggerBuilder>();
  
  /**
   * This method has been deprecated, please use method buildLabelSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public LabelSelector buildLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public A withLabelSelector(LabelSelector labelSelector) {
    _visitables.get("labelSelector").remove(this.labelSelector);
    if (labelSelector!=null){ this.labelSelector= new LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} else { this.labelSelector = null; _visitables.get("labelSelector").remove(this.labelSelector); } return (A) this;
  }
  public Boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public EventListenerSpecFluentImpl.LabelSelectorNested<A> withNewLabelSelector() {
    return new EventListenerSpecFluentImpl.LabelSelectorNestedImpl();
  }
  public EventListenerSpecFluentImpl.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new EventListenerSpecFluentImpl.LabelSelectorNestedImpl(item);
  }
  public EventListenerSpecFluentImpl.LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector());
  }
  public EventListenerSpecFluentImpl.LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new LabelSelectorBuilder().build());
  }
  public EventListenerSpecFluentImpl.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public NamespaceSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new NamespaceSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public EventListenerSpecFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new EventListenerSpecFluentImpl.NamespaceSelectorNestedImpl();
  }
  public EventListenerSpecFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new EventListenerSpecFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public EventListenerSpecFluentImpl.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public EventListenerSpecFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new NamespaceSelectorBuilder().build());
  }
  public EventListenerSpecFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public Resources getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public Resources buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(Resources resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourcesBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public EventListenerSpecFluentImpl.ResourcesNested<A> withNewResources() {
    return new EventListenerSpecFluentImpl.ResourcesNestedImpl();
  }
  public EventListenerSpecFluentImpl.ResourcesNested<A> withNewResourcesLike(Resources item) {
    return new EventListenerSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public EventListenerSpecFluentImpl.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public EventListenerSpecFluentImpl.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourcesBuilder().build());
  }
  public EventListenerSpecFluentImpl.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public A addToTriggers(int index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").add(index, builder); triggers.add(index, builder);}
    return (A)this;
  }
  public A setToTriggers(int index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").set(index, builder); triggers.set(index, builder);}
    return (A)this;
  }
  public A addToTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A addAllToTriggers(Collection<EventListenerTrigger> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  public A removeFromTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... items) {
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeAllFromTriggers(Collection<EventListenerTrigger> items) {
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder);if (this.triggers != null) {this.triggers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTriggers(Predicate<EventListenerTriggerBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<EventListenerTriggerBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      EventListenerTriggerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTriggers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EventListenerTrigger> getTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public List<EventListenerTrigger> buildTriggers() {
    return triggers != null ? build(triggers) : null;
  }
  public EventListenerTrigger buildTrigger(int index) {
    return this.triggers.get(index).build();
  }
  public EventListenerTrigger buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  public EventListenerTrigger buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  public EventListenerTrigger buildMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    for (EventListenerTriggerBuilder item: triggers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    for (EventListenerTriggerBuilder item: triggers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTriggers(List<EventListenerTrigger> triggers) {
    if (this.triggers != null) { _visitables.get("triggers").clear();}
    if (triggers != null) {this.triggers = new ArrayList(); for (EventListenerTrigger item : triggers){this.addToTriggers(item);}} else { this.triggers = null;} return (A) this;
  }
  public A withTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... triggers) {
    if (this.triggers != null) {this.triggers.clear(); _visitables.remove("triggers"); }
    if (triggers != null) {for (EventListenerTrigger item :triggers){ this.addToTriggers(item);}} return (A) this;
  }
  public Boolean hasTriggers() {
    return triggers != null && !triggers.isEmpty();
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> addNewTrigger() {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl();
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> addNewTriggerLike(EventListenerTrigger item) {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl(-1, item);
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> setNewTriggerLike(int index,EventListenerTrigger item) {
    return new EventListenerSpecFluentImpl.TriggersNestedImpl(index, item);
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> editTrigger(int index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public EventListenerSpecFluentImpl.TriggersNested<A> editMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventListenerSpecFluentImpl that = (EventListenerSpecFluentImpl) o;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;

    if (!java.util.Objects.equals(triggers, that.triggers)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(labelSelector,  namespaceSelector,  resources,  serviceAccountName,  triggers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (triggers != null) { sb.append("triggers:"); sb.append(triggers); }
    sb.append("}");
    return sb.toString();
  }
  class LabelSelectorNestedImpl<N> extends LabelSelectorFluentImpl<EventListenerSpecFluentImpl.LabelSelectorNested<N>> implements EventListenerSpecFluentImpl.LabelSelectorNested<N>,Nested<N>{
    LabelSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends NamespaceSelectorFluentImpl<EventListenerSpecFluentImpl.NamespaceSelectorNested<N>> implements EventListenerSpecFluentImpl.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new NamespaceSelectorBuilder(this);
    }
    NamespaceSelectorBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourcesFluentImpl<EventListenerSpecFluentImpl.ResourcesNested<N>> implements EventListenerSpecFluentImpl.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(Resources item) {
      this.builder = new ResourcesBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourcesBuilder(this);
    }
    ResourcesBuilder builder;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class TriggersNestedImpl<N> extends EventListenerTriggerFluentImpl<EventListenerSpecFluentImpl.TriggersNested<N>> implements EventListenerSpecFluentImpl.TriggersNested<N>,Nested<N>{
    TriggersNestedImpl(int index,EventListenerTrigger item) {
      this.index = index;
      this.builder = new EventListenerTriggerBuilder(this, item);
    }
    TriggersNestedImpl() {
      this.index = -1;
      this.builder = new EventListenerTriggerBuilder(this);
    }
    EventListenerTriggerBuilder builder;
    int index;
    public N and() {
      return (N) EventListenerSpecFluentImpl.this.setToTriggers(index,builder.build());
    }
    public N endTrigger() {
      return and();
    }
    
  }
  
}