package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CELInterceptorFluentImpl<A extends CELInterceptorFluent<A>> extends BaseFluent<A> implements CELInterceptorFluent<A>{
  public CELInterceptorFluentImpl() {
  }
  public CELInterceptorFluentImpl(CELInterceptor instance) {
    if (instance != null) {
      this.withFilter(instance.getFilter());
      this.withOverlays(instance.getOverlays());
    }
  }
  private String filter;
  private ArrayList<CELOverlayBuilder> overlays = new ArrayList<CELOverlayBuilder>();
  public String getFilter() {
    return this.filter;
  }
  public A withFilter(String filter) {
    this.filter=filter; return (A) this;
  }
  public Boolean hasFilter() {
    return this.filter != null;
  }
  public A addToOverlays(int index,CELOverlay item) {
    if (this.overlays == null) {this.overlays = new ArrayList<CELOverlayBuilder>();}
    CELOverlayBuilder builder = new CELOverlayBuilder(item);
    if (index < 0 || index >= overlays.size()) { _visitables.get("overlays").add(builder); overlays.add(builder); } else { _visitables.get("overlays").add(index, builder); overlays.add(index, builder);}
    return (A)this;
  }
  public A setToOverlays(int index,CELOverlay item) {
    if (this.overlays == null) {this.overlays = new ArrayList<CELOverlayBuilder>();}
    CELOverlayBuilder builder = new CELOverlayBuilder(item);
    if (index < 0 || index >= overlays.size()) { _visitables.get("overlays").add(builder); overlays.add(builder); } else { _visitables.get("overlays").set(index, builder); overlays.set(index, builder);}
    return (A)this;
  }
  public A addToOverlays(io.fabric8.tekton.triggers.v1alpha1.CELOverlay... items) {
    if (this.overlays == null) {this.overlays = new ArrayList<CELOverlayBuilder>();}
    for (CELOverlay item : items) {CELOverlayBuilder builder = new CELOverlayBuilder(item);_visitables.get("overlays").add(builder);this.overlays.add(builder);} return (A)this;
  }
  public A addAllToOverlays(Collection<CELOverlay> items) {
    if (this.overlays == null) {this.overlays = new ArrayList<CELOverlayBuilder>();}
    for (CELOverlay item : items) {CELOverlayBuilder builder = new CELOverlayBuilder(item);_visitables.get("overlays").add(builder);this.overlays.add(builder);} return (A)this;
  }
  public A removeFromOverlays(io.fabric8.tekton.triggers.v1alpha1.CELOverlay... items) {
    for (CELOverlay item : items) {CELOverlayBuilder builder = new CELOverlayBuilder(item);_visitables.get("overlays").remove(builder);if (this.overlays != null) {this.overlays.remove(builder);}} return (A)this;
  }
  public A removeAllFromOverlays(Collection<CELOverlay> items) {
    for (CELOverlay item : items) {CELOverlayBuilder builder = new CELOverlayBuilder(item);_visitables.get("overlays").remove(builder);if (this.overlays != null) {this.overlays.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOverlays(Predicate<CELOverlayBuilder> predicate) {
    if (overlays == null) return (A) this;
    final Iterator<CELOverlayBuilder> each = overlays.iterator();
    final List visitables = _visitables.get("overlays");
    while (each.hasNext()) {
      CELOverlayBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOverlays instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CELOverlay> getOverlays() {
    return overlays != null ? build(overlays) : null;
  }
  public List<CELOverlay> buildOverlays() {
    return overlays != null ? build(overlays) : null;
  }
  public CELOverlay buildOverlay(int index) {
    return this.overlays.get(index).build();
  }
  public CELOverlay buildFirstOverlay() {
    return this.overlays.get(0).build();
  }
  public CELOverlay buildLastOverlay() {
    return this.overlays.get(overlays.size() - 1).build();
  }
  public CELOverlay buildMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
    for (CELOverlayBuilder item: overlays) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
    for (CELOverlayBuilder item: overlays) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOverlays(List<CELOverlay> overlays) {
    if (this.overlays != null) { _visitables.get("overlays").clear();}
    if (overlays != null) {this.overlays = new ArrayList(); for (CELOverlay item : overlays){this.addToOverlays(item);}} else { this.overlays = null;} return (A) this;
  }
  public A withOverlays(io.fabric8.tekton.triggers.v1alpha1.CELOverlay... overlays) {
    if (this.overlays != null) {this.overlays.clear(); _visitables.remove("overlays"); }
    if (overlays != null) {for (CELOverlay item :overlays){ this.addToOverlays(item);}} return (A) this;
  }
  public Boolean hasOverlays() {
    return overlays != null && !overlays.isEmpty();
  }
  public A addNewOverlay(String expression,String key) {
    return (A)addToOverlays(new CELOverlay(expression, key));
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> addNewOverlay() {
    return new CELInterceptorFluentImpl.OverlaysNestedImpl();
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> addNewOverlayLike(CELOverlay item) {
    return new CELInterceptorFluentImpl.OverlaysNestedImpl(-1, item);
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> setNewOverlayLike(int index,CELOverlay item) {
    return new CELInterceptorFluentImpl.OverlaysNestedImpl(index, item);
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> editOverlay(int index) {
    if (overlays.size() <= index) throw new RuntimeException("Can't edit overlays. Index exceeds size.");
    return setNewOverlayLike(index, buildOverlay(index));
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> editFirstOverlay() {
    if (overlays.size() == 0) throw new RuntimeException("Can't edit first overlays. The list is empty.");
    return setNewOverlayLike(0, buildOverlay(0));
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> editLastOverlay() {
    int index = overlays.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last overlays. The list is empty.");
    return setNewOverlayLike(index, buildOverlay(index));
  }
  public CELInterceptorFluentImpl.OverlaysNested<A> editMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
    int index = -1;
    for (int i=0;i<overlays.size();i++) { 
    if (predicate.test(overlays.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching overlays. No match found.");
    return setNewOverlayLike(index, buildOverlay(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CELInterceptorFluentImpl that = (CELInterceptorFluentImpl) o;
    if (!java.util.Objects.equals(filter, that.filter)) return false;

    if (!java.util.Objects.equals(overlays, that.overlays)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(filter,  overlays,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (overlays != null) { sb.append("overlays:"); sb.append(overlays); }
    sb.append("}");
    return sb.toString();
  }
  class OverlaysNestedImpl<N> extends CELOverlayFluentImpl<CELInterceptorFluentImpl.OverlaysNested<N>> implements CELInterceptorFluentImpl.OverlaysNested<N>,Nested<N>{
    OverlaysNestedImpl(int index,CELOverlay item) {
      this.index = index;
      this.builder = new CELOverlayBuilder(this, item);
    }
    OverlaysNestedImpl() {
      this.index = -1;
      this.builder = new CELOverlayBuilder(this);
    }
    CELOverlayBuilder builder;
    int index;
    public N and() {
      return (N) CELInterceptorFluentImpl.this.setToOverlays(index,builder.build());
    }
    public N endOverlay() {
      return and();
    }
    
  }
  
}