package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition;
import java.lang.Integer;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionBuilder;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.ConditionFluentImpl;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1alpha1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EventListenerStatusFluentImpl<A extends EventListenerStatusFluent<A>> extends BaseFluent<A> implements EventListenerStatusFluent<A>{
  public EventListenerStatusFluentImpl() {
  }
  public EventListenerStatusFluentImpl(EventListenerStatus instance) {
    this.withAddress(instance.getAddress()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withConditions(instance.getConditions()); 
    this.withConfiguration(instance.getConfiguration()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
  }
  private AddressableBuilder address;
  private Map<String,String> annotations;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private EventListenerConfigBuilder configuration;
  private Long observedGeneration;
  
  /**
   * This method has been deprecated, please use method buildAddress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Addressable getAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public Addressable buildAddress() {
    return this.address!=null ?this.address.build():null;
  }
  public A withAddress(Addressable address) {
    _visitables.get("address").remove(this.address);
    if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} else { this.address = null; _visitables.get("address").remove(this.address); } return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A withNewV1alpha1Address(String hostname,String url) {
    return (A)withAddress(new Addressable(hostname, url));
  }
  public EventListenerStatusFluent.V1alpha1AddressNested<A> withNewV1alpha1Address() {
    return new EventListenerStatusFluentImpl.V1alpha1AddressNestedImpl();
  }
  public EventListenerStatusFluent.V1alpha1AddressNested<A> withNewAddressLike(Addressable item) {
    return new EventListenerStatusFluentImpl.V1alpha1AddressNestedImpl(item);
  }
  public EventListenerStatusFluent.V1alpha1AddressNested<A> editV1alpha1Address() {
    return withNewAddressLike(getAddress());
  }
  public EventListenerStatusFluent.V1alpha1AddressNested<A> editOrNewAddress() {
    return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
  }
  public EventListenerStatusFluent.V1alpha1AddressNested<A> editOrNewAddressLike(Addressable item) {
    return withNewAddressLike(getAddress() != null ? getAddress(): item);
  }
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition... items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Condition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<Condition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public Condition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
    for (ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.tekton.triggers.internal.knative.pkg.apis.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public EventListenerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new EventListenerStatusFluentImpl.ConditionsNestedImpl();
  }
  public EventListenerStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
    return new EventListenerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public EventListenerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,Condition item) {
    return new EventListenerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public EventListenerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public EventListenerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public EventListenerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public EventListenerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  /**
   * This method has been deprecated, please use method buildConfiguration instead.
   * @return The buildable object.
   */
  @Deprecated
  public EventListenerConfig getConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public EventListenerConfig buildConfiguration() {
    return this.configuration!=null ?this.configuration.build():null;
  }
  public A withConfiguration(EventListenerConfig configuration) {
    _visitables.get("configuration").remove(this.configuration);
    if (configuration!=null){ this.configuration= new EventListenerConfigBuilder(configuration); _visitables.get("configuration").add(this.configuration);} else { this.configuration = null; _visitables.get("configuration").remove(this.configuration); } return (A) this;
  }
  public Boolean hasConfiguration() {
    return this.configuration != null;
  }
  public A withNewConfiguration(String generatedName) {
    return (A)withConfiguration(new EventListenerConfig(generatedName));
  }
  public EventListenerStatusFluent.ConfigurationNested<A> withNewConfiguration() {
    return new EventListenerStatusFluentImpl.ConfigurationNestedImpl();
  }
  public EventListenerStatusFluent.ConfigurationNested<A> withNewConfigurationLike(EventListenerConfig item) {
    return new EventListenerStatusFluentImpl.ConfigurationNestedImpl(item);
  }
  public EventListenerStatusFluent.ConfigurationNested<A> editConfiguration() {
    return withNewConfigurationLike(getConfiguration());
  }
  public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfiguration() {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new EventListenerConfigBuilder().build());
  }
  public EventListenerStatusFluent.ConfigurationNested<A> editOrNewConfigurationLike(EventListenerConfig item) {
    return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EventListenerStatusFluentImpl that = (EventListenerStatusFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  annotations,  conditions,  configuration,  observedGeneration,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (configuration != null) { sb.append("configuration:"); sb.append(configuration + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration); }
    sb.append("}");
    return sb.toString();
  }
  class V1alpha1AddressNestedImpl<N> extends AddressableFluentImpl<EventListenerStatusFluent.V1alpha1AddressNested<N>> implements EventListenerStatusFluent.V1alpha1AddressNested<N>,Nested<N>{
    V1alpha1AddressNestedImpl(Addressable item) {
      this.builder = new AddressableBuilder(this, item);
    }
    V1alpha1AddressNestedImpl() {
      this.builder = new AddressableBuilder(this);
    }
    AddressableBuilder builder;
    public N and() {
      return (N) EventListenerStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endV1alpha1Address() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends ConditionFluentImpl<EventListenerStatusFluent.ConditionsNested<N>> implements EventListenerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new ConditionBuilder(this);
    }
    ConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) EventListenerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class ConfigurationNestedImpl<N> extends EventListenerConfigFluentImpl<EventListenerStatusFluent.ConfigurationNested<N>> implements EventListenerStatusFluent.ConfigurationNested<N>,Nested<N>{
    ConfigurationNestedImpl(EventListenerConfig item) {
      this.builder = new EventListenerConfigBuilder(this, item);
    }
    ConfigurationNestedImpl() {
      this.builder = new EventListenerConfigBuilder(this);
    }
    EventListenerConfigBuilder builder;
    public N and() {
      return (N) EventListenerStatusFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration() {
      return and();
    }
    
  }
  
}