/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerStateRunning;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.tekton.pipeline.v1beta1.StepState;
import io.fabric8.tekton.pipeline.v1beta1.StepStateFluent;
import java.util.Objects;

public class StepStateFluentImpl<A extends StepStateFluent<A>>
extends BaseFluent<A>
implements StepStateFluent<A> {
    private String container;
    private String imageID;
    private String name;
    private ContainerStateRunning running;
    private ContainerStateTerminated terminated;
    private ContainerStateWaiting waiting;

    public StepStateFluentImpl() {
    }

    public StepStateFluentImpl(StepState instance) {
        this.withContainer(instance.getContainer());
        this.withImageID(instance.getImageID());
        this.withName(instance.getName());
        this.withRunning(instance.getRunning());
        this.withTerminated(instance.getTerminated());
        this.withWaiting(instance.getWaiting());
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    public String getImageID() {
        return this.imageID;
    }

    @Override
    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    @Override
    public Boolean hasImageID() {
        return this.imageID != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public ContainerStateRunning getRunning() {
        return this.running;
    }

    @Override
    public A withRunning(ContainerStateRunning running) {
        this.running = running;
        return (A)this;
    }

    @Override
    public Boolean hasRunning() {
        return this.running != null;
    }

    @Override
    public A withNewRunning(String startedAt) {
        return this.withRunning(new ContainerStateRunning(startedAt));
    }

    @Override
    public ContainerStateTerminated getTerminated() {
        return this.terminated;
    }

    @Override
    public A withTerminated(ContainerStateTerminated terminated) {
        this.terminated = terminated;
        return (A)this;
    }

    @Override
    public Boolean hasTerminated() {
        return this.terminated != null;
    }

    @Override
    public ContainerStateWaiting getWaiting() {
        return this.waiting;
    }

    @Override
    public A withWaiting(ContainerStateWaiting waiting) {
        this.waiting = waiting;
        return (A)this;
    }

    @Override
    public Boolean hasWaiting() {
        return this.waiting != null;
    }

    @Override
    public A withNewWaiting(String message, String reason) {
        return this.withWaiting(new ContainerStateWaiting(message, reason));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepStateFluentImpl that = (StepStateFluentImpl)o;
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.imageID != null ? !this.imageID.equals(that.imageID) : that.imageID != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.running != null ? !this.running.equals((Object)that.running) : that.running != null) {
            return false;
        }
        if (this.terminated != null ? !this.terminated.equals((Object)that.terminated) : that.terminated != null) {
            return false;
        }
        return !(this.waiting != null ? !this.waiting.equals((Object)that.waiting) : that.waiting != null);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.imageID, this.name, this.running, this.terminated, this.waiting, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running + ",");
        }
        if (this.terminated != null) {
            sb.append("terminated:");
            sb.append(this.terminated + ",");
        }
        if (this.waiting != null) {
            sb.append("waiting:");
            sb.append(this.waiting);
        }
        sb.append("}");
        return sb.toString();
    }
}

