package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParamSpecBuilder extends ParamSpecFluentImpl<ParamSpecBuilder> implements VisitableBuilder<ParamSpec,ParamSpecBuilder>{
  public ParamSpecBuilder() {
    this(false);
  }
  public ParamSpecBuilder(Boolean validationEnabled) {
    this(new ParamSpec(), validationEnabled);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParamSpec(), validationEnabled);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance) {
    this(fluent, instance, false);
  }
  public ParamSpecBuilder(ParamSpecFluent<?> fluent,ParamSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefault(instance.getDefault()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public ParamSpecBuilder(ParamSpec instance) {
    this(instance,false);
  }
  public ParamSpecBuilder(ParamSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefault(instance.getDefault()); 
    this.withDescription(instance.getDescription()); 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  ParamSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ParamSpec build() {
    ParamSpec buildable = new ParamSpec(fluent.getDefault(),fluent.getDescription(),fluent.getName());
    return buildable;
  }
  
}