package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterTriggerBindingListBuilder extends ClusterTriggerBindingListFluentImpl<ClusterTriggerBindingListBuilder> implements VisitableBuilder<ClusterTriggerBindingList,ClusterTriggerBindingListBuilder>{
  public ClusterTriggerBindingListBuilder() {
    this(false);
  }
  public ClusterTriggerBindingListBuilder(Boolean validationEnabled) {
    this(new ClusterTriggerBindingList(), validationEnabled);
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterTriggerBindingList(), validationEnabled);
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,ClusterTriggerBindingList instance) {
    this(fluent, instance, false);
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingListFluent<?> fluent,ClusterTriggerBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingList instance) {
    this(instance,false);
  }
  public ClusterTriggerBindingListBuilder(ClusterTriggerBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterTriggerBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterTriggerBindingList build() {
    ClusterTriggerBindingList buildable = new ClusterTriggerBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}