package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterTriggerBindingBuilder extends ClusterTriggerBindingFluentImpl<ClusterTriggerBindingBuilder> implements VisitableBuilder<ClusterTriggerBinding,ClusterTriggerBindingBuilder>{
  public ClusterTriggerBindingBuilder() {
    this(false);
  }
  public ClusterTriggerBindingBuilder(Boolean validationEnabled) {
    this(new ClusterTriggerBinding(), validationEnabled);
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterTriggerBinding(), validationEnabled);
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,ClusterTriggerBinding instance) {
    this(fluent, instance, false);
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBindingFluent<?> fluent,ClusterTriggerBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBinding instance) {
    this(instance,false);
  }
  public ClusterTriggerBindingBuilder(ClusterTriggerBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterTriggerBindingFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterTriggerBinding build() {
    ClusterTriggerBinding buildable = new ClusterTriggerBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}