package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterInterceptorListBuilder extends ClusterInterceptorListFluentImpl<ClusterInterceptorListBuilder> implements VisitableBuilder<ClusterInterceptorList,ClusterInterceptorListBuilder>{
  public ClusterInterceptorListBuilder() {
    this(false);
  }
  public ClusterInterceptorListBuilder(Boolean validationEnabled) {
    this(new ClusterInterceptorList(), validationEnabled);
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterInterceptorList(), validationEnabled);
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorListFluent<?> fluent,ClusterInterceptorList instance) {
    this(fluent, instance, false);
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorListFluent<?> fluent,ClusterInterceptorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorList instance) {
    this(instance,false);
  }
  public ClusterInterceptorListBuilder(ClusterInterceptorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterInterceptorListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterInterceptorList build() {
    ClusterInterceptorList buildable = new ClusterInterceptorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}