package io.fabric8.tekton.triggers.internal.knative.pkg.apis.duck.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AddressableBuilder extends AddressableFluentImpl<AddressableBuilder> implements VisitableBuilder<Addressable,AddressableBuilder>{
  public AddressableBuilder() {
    this(false);
  }
  public AddressableBuilder(Boolean validationEnabled) {
    this(new Addressable(), validationEnabled);
  }
  public AddressableBuilder(AddressableFluent<?> fluent) {
    this(fluent, false);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Addressable(), validationEnabled);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance) {
    this(fluent, instance, false);
  }
  public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  public AddressableBuilder(Addressable instance) {
    this(instance,false);
  }
  public AddressableBuilder(Addressable instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  AddressableFluent<?> fluent;
  Boolean validationEnabled;
  public Addressable build() {
    Addressable buildable = new Addressable(fluent.getUrl());
    return buildable;
  }
  
}