package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceReferenceBuilder extends ServiceReferenceFluentImpl<ServiceReferenceBuilder> implements VisitableBuilder<ServiceReference,ServiceReferenceBuilder>{
  public ServiceReferenceBuilder() {
    this(false);
  }
  public ServiceReferenceBuilder(Boolean validationEnabled) {
    this(new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceReference(), validationEnabled);
  }
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,ServiceReference instance) {
    this(fluent, instance, false);
  }
  public ServiceReferenceBuilder(ServiceReferenceFluent<?> fluent,ServiceReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceReferenceBuilder(ServiceReference instance) {
    this(instance,false);
  }
  public ServiceReferenceBuilder(ServiceReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceReference build() {
    ServiceReference buildable = new ServiceReference(fluent.getName(),fluent.getNamespace(),fluent.getPath(),fluent.getPort());
    return buildable;
  }
  
}