package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BitbucketInterceptorBuilder extends BitbucketInterceptorFluentImpl<BitbucketInterceptorBuilder> implements VisitableBuilder<BitbucketInterceptor,BitbucketInterceptorBuilder>{
  public BitbucketInterceptorBuilder() {
    this(false);
  }
  public BitbucketInterceptorBuilder(Boolean validationEnabled) {
    this(new BitbucketInterceptor(), validationEnabled);
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent) {
    this(fluent, false);
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BitbucketInterceptor(), validationEnabled);
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,BitbucketInterceptor instance) {
    this(fluent, instance, false);
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptorFluent<?> fluent,BitbucketInterceptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEventTypes(instance.getEventTypes()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptor instance) {
    this(instance,false);
  }
  public BitbucketInterceptorBuilder(BitbucketInterceptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEventTypes(instance.getEventTypes()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  BitbucketInterceptorFluent<?> fluent;
  Boolean validationEnabled;
  public BitbucketInterceptor build() {
    BitbucketInterceptor buildable = new BitbucketInterceptor(fluent.getEventTypes(),fluent.getSecretRef());
    return buildable;
  }
  
}