package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerTemplateSpecBuilder extends TriggerTemplateSpecFluentImpl<TriggerTemplateSpecBuilder> implements VisitableBuilder<TriggerTemplateSpec,TriggerTemplateSpecBuilder>{
  public TriggerTemplateSpecBuilder() {
    this(false);
  }
  public TriggerTemplateSpecBuilder(Boolean validationEnabled) {
    this(new TriggerTemplateSpec(), validationEnabled);
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerTemplateSpec(), validationEnabled);
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,TriggerTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpecFluent<?> fluent,TriggerTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withParams(instance.getParams()); 
    fluent.withResourcetemplates(instance.getResourcetemplates()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpec instance) {
    this(instance,false);
  }
  public TriggerTemplateSpecBuilder(TriggerTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withParams(instance.getParams()); 
    this.withResourcetemplates(instance.getResourcetemplates()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerTemplateSpec build() {
    TriggerTemplateSpec buildable = new TriggerTemplateSpec(fluent.getParams(),fluent.getResourcetemplates());
    return buildable;
  }
  
}